/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.net;

import com.isencia.message.ChannelException;
import com.isencia.message.WriterSenderChannel;
import com.isencia.message.generator.IMessageGenerator;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketSenderChannel
extends WriterSenderChannel {
    private static final Logger logger = LoggerFactory.getLogger(SocketSenderChannel.class);
    private Socket socket = null;

    public SocketSenderChannel(Socket socket, IMessageGenerator iMessageGenerator) {
        super(iMessageGenerator);
        if (socket != null) {
            this.socket = socket;
        }
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (this.getWriter() != null) {
            try {
                this.getWriter().close();
            }
            catch (IOException iOException) {
                logger.error("open() - Could not close reader", (Throwable)iOException);
            }
            this.setWriter(null);
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.socket.getOutputStream());
            this.setWriter(outputStreamWriter);
        }
        catch (IOException iOException) {
            logger.error("open() - Error getting outputstream from socket", (Throwable)iOException);
            throw new ChannelException("Error getting outputstream from socket " + iOException.getMessage());
        }
        super.open();
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public void close() throws ChannelException {
        try {
            this.getSocket().close();
        }
        catch (Exception exception) {}
        super.close();
    }
}

