/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.net;

import com.isencia.message.ChannelException;
import com.isencia.message.WriterSenderChannel;
import com.isencia.message.generator.IMessageGenerator;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClientSenderChannel
extends WriterSenderChannel {
    private static final Logger logger = LoggerFactory.getLogger(SocketClientSenderChannel.class);
    private static final int retryCountMax = 10;
    private static final int retryWaitMin = 1000;
    private static final int retryWaitMax = 10000;
    private Socket socket = null;
    private String host = null;
    private int port = -1;
    private int retryWaitStep = 900;

    public SocketClientSenderChannel(String string, int n, IMessageGenerator iMessageGenerator) {
        super(iMessageGenerator);
        this.host = string;
        this.port = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ChannelException {
        OutputStreamWriter outputStreamWriter;
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (this.getSocket() != null) {
            try {
                this.getSocket().close();
            }
            catch (IOException iOException) {
                logger.error("open() - Could not close socket", (Throwable)iOException);
            }
            this.setSocket(null);
        }
        if (this.getWriter() != null) {
            try {
                this.getWriter().close();
            }
            catch (IOException iOException) {
                logger.error("open() - Could not close reader", (Throwable)iOException);
            }
            this.setWriter(null);
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.getHost());
        }
        catch (UnknownHostException unknownHostException) {
            throw new ChannelException("Unkown host :" + this.getHost());
        }
        Socket socket = null;
        int n = 0;
        while (n < 10 && socket == null) {
            try {
                socket = new Socket(inetAddress, this.getPort());
            }
            catch (ConnectException connectException) {
                long l = 1000 + this.retryWaitStep * n;
                logger.info("open() - Socket connection to " + this.getHost() + ":" + this.getPort() + " failed." + "\nRetry count " + ++n + "/" + 10);
                SocketClientSenderChannel socketClientSenderChannel = this;
                synchronized (socketClientSenderChannel) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                logger.error("open() - ", (Throwable)iOException);
                break;
            }
        }
        if (socket != null) {
            outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(socket.getOutputStream());
            }
            catch (IOException iOException) {
                try {
                    socket.close();
                }
                catch (IOException iOException2) {}
                throw new ChannelException("Could not open writer for socket to " + this.getHost() + ":" + this.getPort());
            }
        }
        throw new ChannelException("Could not open socket to " + this.getHost() + ":" + this.getPort());
        this.setSocket(socket);
        this.setWriter(outputStreamWriter);
        super.open();
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void close() throws ChannelException {
        logger.trace("close() - entry");
        try {
            if (this.getSocket() != null) {
                this.getSocket().close();
            }
        }
        catch (IOException iOException) {
            logger.error("close() - Error closing socket", (Throwable)iOException);
        }
        super.close();
        logger.trace("close() - exit");
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
        this.setHost(socket.getInetAddress().getHostName());
        this.setPort(socket.getPort());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }
}

