/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.net;

import com.isencia.message.ChannelException;
import com.isencia.message.ReceiverChannel;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastReceiverChannel
extends ReceiverChannel {
    private static final Logger logger = LoggerFactory.getLogger(MulticastReceiverChannel.class);
    private static final int defaultByteBufferSize = 8192;
    private MulticastSocket socket = null;
    private int port = -1;
    private String groupName = "";
    private InetAddress group = null;

    public MulticastReceiverChannel(MulticastSocket multicastSocket) throws ChannelException {
        if (multicastSocket != null) {
            this.socket = multicastSocket;
            this.setPort(multicastSocket.getLocalPort());
        }
    }

    public MulticastReceiverChannel(String string, int n) throws ChannelException {
        this.setPort(n);
        this.setGroupName(string);
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (this.socket == null) {
            try {
                this.socket = new MulticastSocket(this.getPort());
                this.socket.joinGroup(this.getGroup());
            }
            catch (UnknownHostException unknownHostException) {
                logger.error("open() - Unknown multicast group " + this.getGroup(), (Throwable)unknownHostException);
                throw new ChannelException("Unknown multicast group " + this.getGroup());
            }
            catch (IOException iOException) {
                logger.error("open() - Socket construction failed on port " + this.port, (Throwable)iOException);
                throw new ChannelException("Socket construction failed on port " + this.port);
            }
        }
        super.open();
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    public MulticastSocket getSocket() {
        return this.socket;
    }

    public int getPort() {
        return this.port;
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void close() throws ChannelException {
        logger.trace("close() - entry");
        try {
            MulticastSocket multicastSocket = this.getSocket();
            if (multicastSocket != null) {
                multicastSocket.leaveGroup(this.getGroup());
            }
            super.close();
        }
        catch (IOException iOException) {
            logger.error("close() - Error closing sockets", (Throwable)iOException);
        }
        logger.trace("close() - exit");
    }

    @Override
    protected Object doGetMessage() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("doGetMessage() - entry");
        }
        try {
            byte[] byArray = new byte[8192];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            this.getSocket().receive(datagramPacket);
            String string = new String(byArray, 0, datagramPacket.getLength());
            if (logger.isTraceEnabled()) {
                logger.trace("doGetMessage() - exit : " + string);
            }
            return string;
        }
        catch (IOException iOException) {
            throw new ChannelException("IOException while receiving DatagramPacket: " + iOException.getMessage());
        }
    }

    public void setGroupName(String string) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("setGroupName() - entry :" + string);
        }
        try {
            this.group = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ChannelException("Unknown host " + string);
        }
        this.groupName = string;
        if (logger.isTraceEnabled()) {
            logger.trace("setGroupName() - exit");
        }
    }

    public void setPort(int n) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("setPort() - entry :" + n);
        }
        if (n < 0) {
            throw new ChannelException("Port (" + n + ") not set correctly");
        }
        this.port = n;
        if (logger.isTraceEnabled()) {
            logger.trace("setPort() - exit");
        }
    }

    public InetAddress getGroup() {
        return this.group;
    }
}

