/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.net;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;

public class DatagramWriter
extends Writer {
    private static final Logger logger = LoggerFactory.getLogger(DatagramWriter.class);
    private DatagramSocket socket = null;
    private CharToByteConverter ctb;
    private static final int defaultByteBufferSize = 8192;
    private byte[] bb;
    private int nextByte = 0;
    private int nBytes = 0;
    private InetAddress remoteHost = null;
    private int remotePort = -1;

    public DatagramWriter(DatagramSocket datagramSocket) {
        this(datagramSocket, CharToByteConverter.getDefault());
    }

    public DatagramWriter(DatagramSocket datagramSocket, String string) throws UnsupportedEncodingException {
        this(datagramSocket, CharToByteConverter.getConverter((String)string));
    }

    public DatagramWriter(DatagramSocket datagramSocket, CharToByteConverter charToByteConverter) {
        super(datagramSocket);
        if (datagramSocket == null) {
            throw new NullPointerException("socket is null");
        }
        this.socket = datagramSocket;
        this.ctb = charToByteConverter;
        this.bb = new byte[8192];
        this.nBytes = 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding() {
        Object object = this.lock;
        synchronized (object) {
            if (this.ctb != null) {
                return this.ctb.getCharacterEncoding();
            }
            return null;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.socket == null) {
            throw new IOException("Socket closed");
        }
    }

    @Override
    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            int n3 = n;
            int n4 = n + n2;
            boolean bl = false;
            while (n3 < n4) {
                boolean bl2 = false;
                try {
                    this.nextByte += this.ctb.convertAny(cArray, n3, n4, this.bb, this.nextByte, this.nBytes);
                    n3 = n4;
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    int n5 = this.ctb.nextCharIndex();
                    if (n5 == n3 && bl) {
                        throw new CharConversionException("Output buffer too small");
                    }
                    n3 = n5;
                    bl2 = true;
                    this.nextByte = this.ctb.nextByteIndex();
                }
                if (this.nextByte < this.nBytes && !bl2) continue;
                this.writeNext(this.bb, 0, this.nextByte);
                this.nextByte = 0;
                bl = true;
            }
        }
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        this.write(cArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                try {
                    this.nextByte += this.ctb.flushAny(this.bb, this.nextByte, this.nBytes);
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    this.nextByte = this.ctb.nextByteIndex();
                }
                if (this.nextByte == 0) break;
                if (this.nextByte <= 0) continue;
                this.writeNext(this.bb, 0, this.nextByte);
                this.nextByte = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.socket == null) {
                return;
            }
            this.flush();
            this.socket.close();
            this.socket = null;
            this.bb = null;
            this.ctb = null;
        }
    }

    protected void writeNext(byte[] byArray, int n, int n2) throws IOException {
        if (this.remoteHost == null || this.remotePort < 0) {
            throw new IOException("Remote host (" + this.remoteHost + ") and/or port (" + this.remotePort + ") not set correctly");
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, n2, this.remoteHost, this.remotePort);
        logger.trace("Sending packet\n" + datagramPacket + "\nto socket\n" + this.socket);
        this.socket.send(datagramPacket);
    }

    public InetAddress getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(InetAddress inetAddress) {
        this.remoteHost = inetAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int n) {
        this.remotePort = n;
    }
}

