/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.net;

import com.isencia.message.ChannelException;
import com.isencia.message.ReceiverChannel;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramReceiverChannel
extends ReceiverChannel {
    private static final Logger logger = LoggerFactory.getLogger(DatagramReceiverChannel.class);
    private static final int defaultByteBufferSize = 8192;
    private DatagramSocket socket = null;
    private int port = -1;

    public DatagramReceiverChannel(DatagramSocket datagramSocket) {
        if (datagramSocket != null) {
            this.socket = datagramSocket;
            this.port = datagramSocket.getLocalPort();
        }
    }

    public DatagramReceiverChannel(int n) {
        this.port = n;
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (this.socket == null) {
            try {
                this.socket = new DatagramSocket(this.getPort());
            }
            catch (SocketException socketException) {
                logger.error("open() - Socket construction failed on port " + this.port, (Throwable)socketException);
                throw new ChannelException("Socket construction failed on port " + this.port);
            }
        }
        super.open();
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    protected Object doGetMessage() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("doGetMessage() - entry");
        }
        try {
            byte[] byArray = new byte[8192];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            this.getSocket().receive(datagramPacket);
            String string = new String(byArray, 0, datagramPacket.getLength());
            if (logger.isTraceEnabled()) {
                logger.trace("doGetMessage() - exit : " + string);
            }
            return string;
        }
        catch (IOException iOException) {
            throw new ChannelException("IOException while receiving DatagramPacket: " + iOException.getMessage());
        }
    }
}

