/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.mail;

import com.isencia.message.ChannelException;
import com.isencia.message.SenderChannel;
import javax.mail.Message;
import javax.mail.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSenderChannel
extends SenderChannel {
    private static final Logger logger = LoggerFactory.getLogger(MailSenderChannel.class);

    @Override
    protected void doSendMessage(Object object) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("doSendMessage() - entry : <" + object + ">");
        }
        try {
            Transport.send((Message)((Message)object));
        }
        catch (Exception exception) {
            throw new ChannelException(exception.getMessage());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("doSendMessage() - exit");
        }
    }

    @Override
    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        if (this.isOpen()) {
            super.close();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (!this.isOpen()) {
            super.open();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }
}

