/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.io;

import com.isencia.message.ChannelException;
import com.isencia.message.WriterSenderChannel;
import com.isencia.message.generator.IMessageGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSenderChannel
extends WriterSenderChannel {
    private static final Logger logger = LoggerFactory.getLogger(FileSenderChannel.class);
    private File destFile = null;
    private String encoding = null;

    public FileSenderChannel(File file, IMessageGenerator iMessageGenerator) {
        super(iMessageGenerator);
        this.destFile = file;
    }

    public FileSenderChannel(File file, String string, IMessageGenerator iMessageGenerator) {
        this(file, iMessageGenerator);
        this.encoding = string;
    }

    @Override
    public void open() throws ChannelException {
        this.open(false);
    }

    public void open(boolean bl) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (this.destFile == null) {
            throw new ChannelException("Destination file is not specified");
        }
        try {
            if (this.encoding != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
                this.setWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding));
            } else {
                this.setWriter(new FileWriter(this.destFile, bl));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ChannelException("UnsupportedEncodingException " + this.encoding);
        }
        catch (IOException iOException) {
            logger.error("Error opening destination file " + this.destFile.getAbsolutePath(), (Throwable)iOException);
            throw new ChannelException("Error opening destination file " + this.destFile.getAbsolutePath() + " : " + iOException.getMessage());
        }
        super.open();
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }
}

