/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.generator;

import com.isencia.message.generator.IMessageGenerator;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTextLineGenerator
implements IMessageGenerator {
    private static final Logger logger = LoggerFactory.getLogger(MessageTextLineGenerator.class);
    private String lineSeparator = System.getProperty("line.separator");
    private Writer writer;

    public MessageTextLineGenerator() {
    }

    public MessageTextLineGenerator(String string) {
        this.lineSeparator = string;
    }

    @Override
    public void open(Writer writer) {
        this.writer = writer;
    }

    @Override
    public boolean isOpen() {
        return this.writer != null;
    }

    @Override
    public void close() {
    }

    @Override
    public void sendMessage(Object object) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("sendMessage() - entry - msg :\n" + object);
        }
        String string = String.valueOf(object.toString()) + this.lineSeparator;
        this.writer.write(string);
        this.writer.flush();
        if (logger.isTraceEnabled()) {
            logger.trace("sendMessage() - exit - Wrote msg :\n" + string);
        }
    }

    @Override
    public IMessageGenerator cloneGenerator() {
        MessageTextLineGenerator messageTextLineGenerator = new MessageTextLineGenerator(this.lineSeparator);
        return messageTextLineGenerator;
    }
}

