/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.ftp;

import com.isencia.message.ChannelException;
import com.isencia.message.WriterSenderChannel;
import com.isencia.message.generator.IMessageGenerator;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpSenderChannel
extends WriterSenderChannel {
    private static final Logger logger = LoggerFactory.getLogger(FtpSenderChannel.class);
    private String server = null;
    private String username = null;
    private String password = null;
    private boolean binaryTransfer = false;
    private boolean passiveMode = true;
    private String remote = null;
    private FTPClient ftp = null;

    public FtpSenderChannel(String string, String string2, String string3, String string4, boolean bl, boolean bl2, IMessageGenerator iMessageGenerator) {
        super(iMessageGenerator);
        this.remote = string;
        this.server = string2;
        this.username = string3;
        this.password = string4;
        this.binaryTransfer = bl;
        this.passiveMode = bl2;
        this.ftp = new FTPClient();
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("");
        }
        if (this.server == null) {
            throw new ChannelException("Server is not specified");
        }
        if (this.username == null) {
            throw new ChannelException("Username is not specified");
        }
        if (this.password == null) {
            throw new ChannelException("Password is not specified");
        }
        if (this.remote == null) {
            throw new ChannelException("File is not specified");
        }
        try {
            this.ftp.connect(this.server);
            logger.debug("Connected to " + this.server + ".");
            int n = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)n)) {
                this.ftp.disconnect();
                logger.error("FTP server refused connection");
                throw new ChannelException("FTP server refused connection");
            }
        }
        catch (IOException iOException) {
            if (this.ftp.isConnected()) {
                try {
                    this.ftp.disconnect();
                }
                catch (IOException iOException2) {}
            }
            logger.error("Could not connect to server");
            throw new ChannelException("Could not connect to server");
        }
        try {
            if (!this.ftp.login(this.username, this.password)) {
                this.ftp.logout();
                throw new ChannelException("Can't login with username " + this.username + " and password " + this.password);
            }
            logger.debug("Remote system is " + this.ftp.getSystemName());
            if (this.binaryTransfer) {
                this.ftp.setFileType(2);
            }
            if (this.passiveMode) {
                this.ftp.enterLocalPassiveMode();
            }
        }
        catch (ChannelException channelException) {
            throw new ChannelException(channelException.getMessage());
        }
        catch (IOException iOException) {
            throw new ChannelException(String.valueOf(iOException.getMessage()) + " (IOException)");
        }
        try {
            this.setWriter(new OutputStreamWriter(this.ftp.storeFileStream(this.remote), "UTF-8"));
        }
        catch (Exception exception) {
            logger.error("Error opening destination file " + this.remote, (Throwable)exception);
            throw new ChannelException("Error opening destination file " + this.remote + " : " + exception.getMessage());
        }
        super.open();
        if (logger.isTraceEnabled()) {
            logger.trace("exit");
        }
    }

    @Override
    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("");
        }
        if (this.isOpen()) {
            super.close();
        }
        try {
            try {
                this.ftp.logout();
            }
            catch (FTPConnectionClosedException fTPConnectionClosedException) {
                throw new ChannelException("Server closed connection.");
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (this.ftp.isConnected()) {
                try {
                    this.ftp.disconnect();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (this.ftp.isConnected()) {
            try {
                this.ftp.disconnect();
            }
            catch (IOException iOException) {}
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit");
        }
    }

    public void setRemoteFileName(String string) {
        this.remote = string;
    }
}

