/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.extractor;

import com.isencia.message.extractor.IMessageExtractor;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlMessageExtractor
extends DefaultHandler
implements IMessageExtractor,
ContentHandler {
    private static final Logger logger = LoggerFactory.getLogger(XmlMessageExtractor.class);
    private XMLReader xmlReader = null;
    private StringBuffer buffer = null;
    private InputSource input = null;
    private SAXParser saxParser = null;
    private int elementCount = 0;
    private Reader reader = null;
    private boolean characterFound = false;

    public XmlMessageExtractor() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            this.saxParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {}
    }

    public boolean initialize() {
        if (logger.isTraceEnabled()) {
            logger.trace("initialize() - entry");
        }
        this.characterFound = false;
        this.elementCount = 0;
        this.buffer = new StringBuffer();
        try {
            this.xmlReader = this.saxParser.getXMLReader();
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setErrorHandler(this);
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            this.input = new InputSource(new ReaderWrapper(this.reader));
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            return false;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            return false;
        }
        catch (SAXException sAXException) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("initialize() - exit");
        }
        return true;
    }

    @Override
    public Object getMessage() {
        if (logger.isTraceEnabled()) {
            logger.trace("getMessage() - entry");
        }
        if (!this.initialize()) {
            if (logger.isTraceEnabled()) {
                logger.trace("getMessage() - exit - not yet initialized! Returning null.");
            }
            return null;
        }
        String string = null;
        try {
            this.xmlReader.parse(this.input);
        }
        catch (IOException iOException) {
            logger.error("getMessage()", (Throwable)iOException);
        }
        catch (SAXEndMessageException sAXEndMessageException) {
            string = this.buffer.toString().trim();
        }
        catch (SAXParseException sAXParseException) {
            if (this.buffer.length() > 0) {
                logger.error("getMessage()", (Throwable)sAXParseException);
            }
        }
        catch (SAXException sAXException) {
            logger.error("getMessage()", (Throwable)sAXException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getMessage() - exit - result :" + string);
        }
        return string;
    }

    @Override
    public void close() {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                logger.error("close() - Error closing reader", (Throwable)iOException);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open(Reader reader) {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry - reader :" + reader);
        }
        this.reader = reader;
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        ++this.elementCount;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        --this.elementCount;
        if (this.elementCount == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("End of parse");
            }
            throw new SAXEndMessageException();
        }
    }

    @Override
    public IMessageExtractor cloneExtractor() {
        XmlMessageExtractor xmlMessageExtractor = new XmlMessageExtractor();
        return xmlMessageExtractor;
    }

    private class ReaderWrapper
    extends Reader {
        Reader reader = null;

        ReaderWrapper(Reader reader) {
            this.reader = reader;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            if (logger.isTraceEnabled()) {
                logger.trace("read() - entry - offset :" + n + " - length :" + n2);
            }
            if (cArray == null) {
                throw new IOException("Null array");
            }
            char[] cArray2 = new char[1];
            int n3 = 0;
            if (!XmlMessageExtractor.this.characterFound) {
                while ((n3 = this.reader.read(cArray2, 0, 1)) > 0 && cArray2[0] != '<' && cArray2[0] != '\uffffffff') {
                }
                if (n3 == 0) {
                    return 0;
                }
                XmlMessageExtractor.this.characterFound = true;
            } else {
                n3 = this.reader.read(cArray2, 0, 1);
            }
            if (n3 > 0 && cArray2[0] != '\uffffffff') {
                cArray[n] = cArray2[0];
                XmlMessageExtractor.this.buffer.append(cArray[n]);
            } else if (logger.isDebugEnabled()) {
                logger.debug("read() - End of file found");
            }
            if (logger.isTraceEnabled()) {
                logger.trace("read() - exit - count :" + n3);
            }
            return n3;
        }
    }

    private class SAXEndMessageException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        SAXEndMessageException() {
            super("EndMessage");
        }
    }
}

