/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.db;

import com.isencia.message.ChannelException;
import com.isencia.message.ReceiverChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseReceiverChannel
extends ReceiverChannel {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseReceiverChannel.class);
    private Connection connection;
    private String query;
    private ResultSet resultSet;
    private ResultSetMetaData metaData;
    private String[] columnNames;

    public DatabaseReceiverChannel(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void open() throws ChannelException {
        if (this.connection == null) {
            throw new ChannelException("No connection specified");
        }
        if (this.query == null) {
            throw new ChannelException("No query specified");
        }
        try {
            this.resultSet = this.connection.createStatement(1003, 1007).executeQuery(this.getQuery());
            this.metaData = this.resultSet.getMetaData();
            this.columnNames = new String[this.metaData.getColumnCount()];
            int n = 0;
            while (n < this.metaData.getColumnCount()) {
                this.columnNames[n] = this.metaData.getColumnLabel(n + 1);
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ChannelException(exception.toString());
        }
        super.open();
    }

    @Override
    public void close() throws ChannelException {
        super.close();
        try {
            this.resultSet.close();
            this.connection.close();
            logger.debug("Channel Closed");
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
    }

    @Override
    protected Object doGetMessage() throws ChannelException {
        HashMap<String, Object> hashMap = null;
        try {
            if (this.resultSet.next()) {
                hashMap = new HashMap<String, Object>();
                int n = 0;
                while (n < this.columnNames.length) {
                    String string = this.columnNames[n];
                    hashMap.put(string, this.resultSet.getObject(string));
                    ++n;
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new ChannelException(exception.getMessage());
        }
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }
}

