/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message;

import com.isencia.message.ChannelException;
import com.isencia.message.SenderChannel;
import com.isencia.message.generator.IMessageGenerator;
import com.isencia.message.generator.MessageTextLineGenerator;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterSenderChannel
extends SenderChannel {
    private static final Logger logger = LoggerFactory.getLogger(WriterSenderChannel.class);
    private Writer writer = null;
    private IMessageGenerator generator = null;

    public WriterSenderChannel(IMessageGenerator iMessageGenerator) {
        if (iMessageGenerator == null) {
            this.setGenerator(new MessageTextLineGenerator());
        } else {
            this.setGenerator(iMessageGenerator);
        }
    }

    @Override
    protected void doSendMessage(Object object) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("doSendMessage() - entry - message :" + object);
        }
        this.getGenerator().sendMessage(object);
        if (logger.isTraceEnabled()) {
            logger.trace("doSendMessage() - exit");
        }
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (!this.isOpen()) {
            super.open();
            this.getGenerator().open(this.getWriter());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    @Override
    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        if (this.isOpen()) {
            super.close();
            this.getGenerator().close();
            if (this.getWriter() != null) {
                try {
                    this.getWriter().close();
                }
                catch (IOException iOException) {
                    throw new ChannelException(iOException.getMessage());
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    public IMessageGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(IMessageGenerator iMessageGenerator) {
        if (logger.isTraceEnabled()) {
            logger.trace("setGenerator() - entry - generator :" + iMessageGenerator);
        }
        this.generator = iMessageGenerator;
        if (logger.isTraceEnabled()) {
            logger.trace("setGenerator() - exit");
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        if (logger.isTraceEnabled()) {
            logger.trace("setWriter() - entry - writer :" + writer);
        }
        this.writer = writer;
        if (logger.isTraceEnabled()) {
            logger.trace("setWriter() - exit");
        }
    }
}

