/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message;

import com.isencia.message.ChannelException;
import com.isencia.message.DefaultSenderChannelHandler;
import com.isencia.message.IMessageProvider;
import com.isencia.message.ISenderChannel;
import com.isencia.message.ISenderChannelHandler;
import com.isencia.message.NoMoreMessagesException;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SenderChannel
implements ISenderChannel,
IMessageProvider {
    private static final Logger logger = LoggerFactory.getLogger(SenderChannel.class);
    private IMessageInterceptorChain interceptorChainOnEnter = null;
    private boolean open = false;
    private Collection<IMessageProvider> providers = new ArrayList<IMessageProvider>();
    private ISenderChannelHandler handler = new DefaultSenderChannelHandler(this);

    @Override
    public void setInterceptorChainOnEnter(IMessageInterceptorChain iMessageInterceptorChain) {
        if (logger.isTraceEnabled()) {
            logger.trace("setInterceptorChainOnEnter() - entry - chain :" + iMessageInterceptorChain);
        }
        this.interceptorChainOnEnter = iMessageInterceptorChain;
        if (logger.isTraceEnabled()) {
            logger.trace("setInterceptorChainOnEnter() - exit");
        }
    }

    @Override
    public Object getMessage() throws NoMoreMessagesException {
        if (logger.isTraceEnabled()) {
            logger.trace("getMessage() - entry");
        }
        Object object = null;
        Collection<IMessageProvider> collection = this.getProviders();
        if (collection == null || collection.size() == 0) {
            logger.error("getMessage() - No providers specified");
            throw new NoMoreMessagesException("No providers specified");
        }
        Iterator<IMessageProvider> iterator = collection.iterator();
        while (iterator.hasNext()) {
            logger.debug("getMessage() - Try to get provider");
            IMessageProvider iMessageProvider = iterator.next();
            if (iMessageProvider == null) continue;
            try {
                object = iMessageProvider.getMessage();
                logger.debug("getMessage() - Found message :" + object);
                break;
            }
            catch (NoMoreMessagesException noMoreMessagesException) {
                logger.debug("getMessage() - No message found");
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getMessage() - exit - message :" + object);
        }
        if (object == null) {
            throw new NoMoreMessagesException();
        }
        try {
            if (this.interceptorChainOnEnter != null) {
                return this.interceptorChainOnEnter.accept(object);
            }
            return object;
        }
        catch (Exception exception) {
            throw new NoMoreMessagesException(exception.getMessage());
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public Collection<IMessageProvider> getProviders() {
        return this.providers;
    }

    @Override
    public void addProvider(IMessageProvider iMessageProvider) {
        if (logger.isTraceEnabled()) {
            logger.trace("addProvider() - entry - provider :" + iMessageProvider);
        }
        this.providers.add(iMessageProvider);
        if (logger.isTraceEnabled()) {
            logger.trace("addProvider() - exit");
        }
    }

    @Override
    public void addProviders(Collection<IMessageProvider> collection) {
        if (logger.isTraceEnabled()) {
            logger.trace("addProviders() - entry - providers :" + collection);
        }
        collection.addAll(collection);
        if (logger.isTraceEnabled()) {
            logger.trace("addProviders() - exit");
        }
    }

    @Override
    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        this.handler.close();
        this.open = false;
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    @Override
    public boolean hasMessage() {
        if (logger.isTraceEnabled()) {
            logger.trace("hasMessage() - entry");
        }
        boolean bl = false;
        Collection<IMessageProvider> collection = this.getProviders();
        for (IMessageProvider iMessageProvider : collection) {
            if (!iMessageProvider.hasMessage()) continue;
            bl = true;
            break;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("hasMessage() - exit - result :" + bl);
        }
        return bl;
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        this.handler.open();
        this.open = true;
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    @Override
    public boolean removeProvider(IMessageProvider iMessageProvider) {
        if (logger.isTraceEnabled()) {
            logger.trace("removeProvider() - entry");
        }
        boolean bl = this.providers.remove(iMessageProvider);
        if (logger.isTraceEnabled()) {
            logger.trace("removeProvider() - exit - result :" + bl);
        }
        return bl;
    }

    @Override
    public void sendMessage(Object object) throws InterruptedException, ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("sendMessage() - entry - message :" + object);
        }
        try {
            if (this.interceptorChainOnEnter != null) {
                this.doSendMessage(this.interceptorChainOnEnter.accept(object));
            } else {
                this.doSendMessage(object);
            }
        }
        catch (Exception exception) {
            throw new ChannelException(exception.getMessage());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("sendMessage() - exit");
        }
    }

    protected abstract void doSendMessage(Object var1) throws Exception;

    @Override
    public void messageAvailable() {
        if (logger.isTraceEnabled()) {
            logger.trace("messageAvailable() - entry");
        }
        this.handler.messageAvailable();
        if (logger.isTraceEnabled()) {
            logger.trace("messageAvailable() - exit");
        }
    }
}

