/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message;

import com.isencia.message.ChannelException;
import com.isencia.message.IMessageListener;
import com.isencia.message.IReceiverChannel;
import com.isencia.message.NoMoreMessagesException;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReceiverChannel
extends Thread
implements IReceiverChannel {
    private static final Logger logger = LoggerFactory.getLogger(ReceiverChannel.class);
    private IMessageInterceptorChain interceptorChainOnLeave = null;
    private Collection<IMessageListener> listeners = new ArrayList<IMessageListener>();
    private boolean open = false;

    @Override
    public void setInterceptorChainOnLeave(IMessageInterceptorChain iMessageInterceptorChain) {
        if (logger.isTraceEnabled()) {
            logger.trace("setInterceptorChainOnLeave() - entry - chain :" + iMessageInterceptorChain);
        }
        this.interceptorChainOnLeave = iMessageInterceptorChain;
        if (logger.isTraceEnabled()) {
            logger.trace("setInterceptorChainOnLeave() - exit");
        }
    }

    @Override
    public Collection<IMessageListener> getListeners() {
        return this.listeners;
    }

    @Override
    public Object getMessage() throws ChannelException, NoMoreMessagesException {
        if (logger.isTraceEnabled()) {
            logger.trace("getMessage() - entry");
        }
        Object object = null;
        try {
            object = this.doGetMessage();
            if (object != null) {
                logger.debug("getMessage() - Received msg from channel : " + object);
                if (this.interceptorChainOnLeave != null) {
                    object = this.interceptorChainOnLeave.accept(object);
                }
            } else {
                logger.debug("getMessage() - No message received");
            }
        }
        catch (ChannelException channelException) {
            throw channelException;
        }
        catch (NoMoreMessagesException noMoreMessagesException) {
            throw noMoreMessagesException;
        }
        catch (Exception exception) {
            throw new ChannelException(exception.toString());
        }
        if (logger.isTraceEnabled()) {
            if (object == null) {
                logger.trace("getMessage() - exit - No message returned");
            } else {
                logger.trace("getMessage() - exit - Return msg : " + object);
            }
        }
        return object;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptMessage(Object object) throws InterruptedException, Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("acceptMessage() - entry - message :" + object);
        }
        Collection<IMessageListener> collection = this.listeners;
        synchronized (collection) {
            Iterator<IMessageListener> iterator = this.listeners.iterator();
            if (object != null) {
                logger.debug("acceptMessage() - Accepted message from channel : " + object);
                if (this.interceptorChainOnLeave != null) {
                    object = this.interceptorChainOnLeave.accept(object);
                }
            } else {
                logger.debug("acceptMessage() - No message received");
            }
            while (iterator.hasNext()) {
                iterator.next().acceptMessage(object, this);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("acceptMessage() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IMessageListener iMessageListener) {
        if (logger.isTraceEnabled()) {
            logger.trace("addListener() - entry - listener :" + iMessageListener);
        }
        Collection<IMessageListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(iMessageListener);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addListener() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListeners(Collection<IMessageListener> collection) {
        if (logger.isTraceEnabled()) {
            logger.trace("addListeners() - entry - listeners :" + collection);
        }
        Collection<IMessageListener> collection2 = this.listeners;
        synchronized (collection2) {
            this.listeners.addAll(collection);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addListeners() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        Collection<IMessageListener> collection = this.listeners;
        synchronized (collection) {
            this.open = false;
            Iterator<IMessageListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().sourceClosed(this);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        Collection<IMessageListener> collection = this.listeners;
        synchronized (collection) {
            if (!this.open) {
                this.open = true;
                Iterator<IMessageListener> iterator = this.getListeners().iterator();
                while (iterator.hasNext()) {
                    iterator.next().sourceOpened(this);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(IMessageListener iMessageListener) {
        if (logger.isTraceEnabled()) {
            logger.trace("removeListener() - entry - listener :" + iMessageListener);
        }
        Collection<IMessageListener> collection = this.listeners;
        synchronized (collection) {
            try {
                boolean bl = this.listeners.remove(iMessageListener);
                if (logger.isTraceEnabled()) {
                    logger.trace("removeListener() - exit - result :" + bl);
                }
                return bl;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                logger.error("removeListener()", (Throwable)unsupportedOperationException);
                return false;
            }
        }
    }

    @Override
    public void run() {
        block24: {
            if (logger.isTraceEnabled()) {
                logger.trace("run() - entry");
            }
            try {
                Object object;
                if (!this.isOpen()) {
                    this.open();
                }
                while ((object = this.doGetMessage()) != null) {
                    this.acceptMessage(object);
                    if (!Thread.currentThread().isInterrupted()) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                try {
                    if (this.isOpen()) {
                        this.close();
                    }
                    break block24;
                }
                catch (Exception exception) {}
                break block24;
            }
            catch (Exception exception) {
                try {
                    logger.error("run()", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.isOpen()) {
                            this.close();
                        }
                    }
                    catch (Exception exception2) {}
                    throw throwable;
                }
                try {
                    if (this.isOpen()) {
                        this.close();
                    }
                    break block24;
                }
                catch (Exception exception3) {}
                break block24;
            }
            try {
                if (this.isOpen()) {
                    this.close();
                }
            }
            catch (Exception exception) {}
        }
        if (logger.isTraceEnabled()) {
            logger.trace("run() - exit");
        }
    }

    protected abstract Object doGetMessage() throws ChannelException, NoMoreMessagesException;
}

