/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message;

import com.isencia.message.ChannelException;
import com.isencia.message.ReceiverChannel;
import com.isencia.message.extractor.IMessageExtractor;
import com.isencia.message.extractor.TextLineMessageExtractor;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderReceiverChannel
extends ReceiverChannel {
    private static final Logger logger = LoggerFactory.getLogger(ReaderReceiverChannel.class);
    private IMessageExtractor extractor = null;
    private Reader reader;

    public ReaderReceiverChannel(IMessageExtractor iMessageExtractor) {
        if (iMessageExtractor == null) {
            this.setExtractor(new TextLineMessageExtractor());
        } else {
            this.setExtractor(iMessageExtractor);
        }
    }

    @Override
    protected Object doGetMessage() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("doGetMessage() - entry");
        }
        Object object = null;
        try {
            object = this.getExtractor().getMessage();
        }
        catch (Exception exception) {
            throw new ChannelException(exception.toString());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("doGetMessage() - exit - Return msg : " + object);
        }
        return object;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        if (logger.isTraceEnabled()) {
            logger.trace("setReader() - entry - reader :" + reader);
        }
        this.reader = reader;
        if (logger.isTraceEnabled()) {
            logger.trace("setReader() - exit");
        }
    }

    @Override
    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        super.close();
        this.getExtractor().close();
        if (this.getReader() != null) {
            try {
                this.getReader().close();
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException.getMessage());
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        super.open();
        this.getExtractor().open(this.getReader());
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    public IMessageExtractor getExtractor() {
        return this.extractor;
    }

    public void setExtractor(IMessageExtractor iMessageExtractor) {
        if (logger.isTraceEnabled()) {
            logger.trace("setExtractor() - entry - extractor :" + iMessageExtractor);
        }
        this.extractor = iMessageExtractor;
        if (logger.isTraceEnabled()) {
            logger.trace("setExtractor() - exit");
        }
    }
}

