/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message;

import com.isencia.message.ChannelException;
import com.isencia.message.IMessageSender;
import com.isencia.message.ISenderChannel;
import com.isencia.message.NoMoreMessagesException;
import com.isencia.util.BlockingReaderQueue;
import com.isencia.util.EmptyQueueException;
import com.isencia.util.FIFOQueue;
import com.isencia.util.IQueue;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSender
implements IMessageSender {
    private static final Logger logger = LoggerFactory.getLogger(MessageSender.class);
    private BlockingReaderQueue queue = new BlockingReaderQueue((IQueue)new FIFOQueue());
    private Collection<ISenderChannel> channels = new ArrayList<ISenderChannel>();
    private MessageLoop msgLoop = null;
    private boolean open = false;

    @Override
    public boolean sendMessage(Object object) {
        if (logger.isTraceEnabled()) {
            logger.trace("sendMessage() - entry - Message: " + object);
        }
        if (!this.open) {
            throw new IllegalStateException("MessageSender is not open");
        }
        boolean bl = this.queue.put(object);
        if (logger.isTraceEnabled()) {
            logger.trace("sendMessage() - exit - ");
        }
        return bl;
    }

    protected boolean hasMessages() {
        return !this.queue.isEmpty();
    }

    protected Object getMessage() throws NoMoreMessagesException {
        if (logger.isTraceEnabled()) {
            logger.trace("getMessage() - entry");
        }
        if (this.open || this.hasMessages()) {
            try {
                Object object = this.queue.get();
                if (logger.isTraceEnabled()) {
                    logger.trace("getMessage() - exit - Result :" + object);
                }
                return object;
            }
            catch (EmptyQueueException emptyQueueException) {
                throw new NoMoreMessagesException(emptyQueueException.toString());
            }
        }
        throw new NoMoreMessagesException("No more messages");
    }

    protected void dispatchMessage(Object object) throws InterruptedException, ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("dispatchMessage() - entry - Dispatching:\n" + object);
        }
        for (ISenderChannel iSenderChannel : this.getChannels()) {
            iSenderChannel.sendMessage(object);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("dispatchMessage() - exit");
        }
    }

    @Override
    public void open() {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        for (ISenderChannel iSenderChannel : this.getChannels()) {
            try {
                iSenderChannel.open();
            }
            catch (ChannelException channelException) {
                logger.error("open() - Error opening channel", (Throwable)channelException);
            }
        }
        if (!this.open) {
            this.open = true;
            this.msgLoop = new MessageLoop();
            this.msgLoop.start();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    @Override
    public void close() {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        this.open = false;
        if (!this.hasMessages()) {
            this.msgLoop.interrupt();
        } else {
            try {
                logger.debug("close() - Joining msg loop...");
                this.msgLoop.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.msgLoop = null;
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    @Override
    public void addChannel(ISenderChannel iSenderChannel) {
        if (logger.isTraceEnabled()) {
            logger.trace("addChannel() - entry - channel :" + iSenderChannel);
        }
        this.getChannels().add(iSenderChannel);
        if (logger.isTraceEnabled()) {
            logger.trace("addChannel() - exit");
        }
    }

    public void closeChannels() {
        if (logger.isTraceEnabled()) {
            logger.trace("closeChannels() - entry");
        }
        for (ISenderChannel iSenderChannel : this.getChannels()) {
            try {
                iSenderChannel.close();
            }
            catch (ChannelException channelException) {
                logger.error("closeChannels() - Error closing channel", (Throwable)channelException);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("closeChannels() - exit");
        }
    }

    @Override
    public Collection<ISenderChannel> getChannels() {
        return this.channels;
    }

    @Override
    public boolean removeChannel(ISenderChannel iSenderChannel) {
        if (logger.isTraceEnabled()) {
            logger.trace("removeChannel() - entry - channel :" + iSenderChannel);
        }
        try {
            boolean bl = this.getChannels().remove(iSenderChannel);
            if (logger.isTraceEnabled()) {
                logger.trace("removeChannel() - exit - Result :" + bl);
            }
            return bl;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            logger.error("removeChannel()", (Throwable)unsupportedOperationException);
            return false;
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    class MessageLoop
    extends Thread {
        MessageLoop() {
        }

        @Override
        public void run() {
            block11: {
                if (logger.isTraceEnabled()) {
                    logger.trace("MessageLoop.run() - entry");
                }
                try {
                    Object object = null;
                    boolean bl = true;
                    int n = 1;
                    while (bl) {
                        object = MessageSender.this.getMessage();
                        if (object == null) {
                            bl = false;
                            continue;
                        }
                        logger.info("MessageLoop.run() - sending msg " + n++ + ":" + object);
                        MessageSender.this.dispatchMessage(object);
                    }
                }
                catch (InterruptedException interruptedException) {
                    MessageSender.this.closeChannels();
                    break block11;
                }
                catch (Exception exception) {
                    try {
                        logger.error("MessageLoop.run()", (Throwable)exception);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        MessageSender.this.closeChannels();
                    }
                }
                MessageSender.this.closeChannels();
            }
            if (logger.isTraceEnabled()) {
                logger.trace("MessageLoop.run() - exit");
            }
        }
    }
}

