/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message;

import com.isencia.message.ChannelException;
import com.isencia.message.IMessageReceiver;
import com.isencia.message.IReceiverChannel;
import com.isencia.message.NoMoreMessagesException;
import com.isencia.message.ReceiverChannel;
import com.isencia.util.BlockingReaderQueue;
import com.isencia.util.EmptyQueueException;
import com.isencia.util.FIFOQueue;
import com.isencia.util.IQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReceiver
implements IMessageReceiver {
    private static final Logger logger = LoggerFactory.getLogger(MessageReceiver.class);
    private boolean autoClose = false;
    private Collection<IReceiverChannel> channels = null;
    private boolean isClosing = false;
    private boolean open = false;
    private Set<IReceiverChannel> openChannels = null;
    private BlockingReaderQueue queue = new BlockingReaderQueue((IQueue)new FIFOQueue());

    public MessageReceiver() {
        this(false);
    }

    public MessageReceiver(boolean bl) {
        this.channels = new ArrayList<IReceiverChannel>();
        this.openChannels = new HashSet<IReceiverChannel>();
        this.autoClose = bl;
    }

    @Override
    public Collection<IReceiverChannel> getChannels() {
        return this.channels;
    }

    @Override
    public Object getMessage() throws NoMoreMessagesException {
        if (logger.isTraceEnabled()) {
            logger.trace("getMessage() - entry");
        }
        if (this.isOpen() || this.hasMessage()) {
            try {
                Object object = this.queue.get();
                if (logger.isTraceEnabled()) {
                    logger.trace("getMessage() - exit");
                }
                return object;
            }
            catch (EmptyQueueException emptyQueueException) {
                throw new NoMoreMessagesException(emptyQueueException.toString());
            }
        }
        throw new NoMoreMessagesException("No more messages");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Set<IReceiverChannel> set = this.openChannels;
        synchronized (set) {
            return this.open;
        }
    }

    @Override
    public void acceptMessage(Object object, IReceiverChannel iReceiverChannel) {
        if (logger.isTraceEnabled()) {
            logger.trace("acceptMessage() - entry - Message: " + object);
        }
        this.queue.put(object);
        if (logger.isTraceEnabled()) {
            logger.trace("acceptMessage() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChannel(IReceiverChannel iReceiverChannel) {
        if (logger.isTraceEnabled()) {
            logger.trace("addChannel() - entry - channel :" + iReceiverChannel);
        }
        iReceiverChannel.addListener(this);
        Collection<IReceiverChannel> collection = this.channels;
        synchronized (collection) {
            this.channels.add(iReceiverChannel);
        }
        if (this.isOpen()) {
            try {
                iReceiverChannel.open();
            }
            catch (ChannelException channelException) {
                logger.error("addChannel() - Error opening channel " + iReceiverChannel, (Throwable)channelException);
                iReceiverChannel.removeListener(this);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addChannel() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        Collection<IReceiverChannel> collection = this.channels;
        synchronized (collection) {
            if (this.getChannels().size() > 0) {
                for (IReceiverChannel iReceiverChannel : this.channels) {
                    try {
                        iReceiverChannel.close();
                    }
                    catch (ChannelException channelException) {
                        logger.error("close() - Error closing channel", (Throwable)channelException);
                    }
                }
            } else {
                this.open = false;
            }
        }
        this.isClosing = true;
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    @Override
    public boolean hasMessage() {
        return !this.queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        Collection<IReceiverChannel> collection = this.channels;
        synchronized (collection) {
            for (IReceiverChannel iReceiverChannel : this.getChannels()) {
                try {
                    iReceiverChannel.open();
                }
                catch (ChannelException channelException) {
                    logger.error("open() - Error opening channel " + iReceiverChannel, (Throwable)channelException);
                }
            }
        }
        this.open = true;
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChannel(IReceiverChannel iReceiverChannel) {
        if (logger.isTraceEnabled()) {
            logger.trace("removeChannel() - entry - channel :" + iReceiverChannel);
        }
        Collection<IReceiverChannel> collection = this.channels;
        synchronized (collection) {
            try {
                ((ReceiverChannel)iReceiverChannel).interrupt();
                boolean bl = this.channels.remove(iReceiverChannel);
                if (logger.isTraceEnabled()) {
                    logger.trace("removeChannel - exit - result :" + bl);
                }
                return bl;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                logger.error("removeChannel()", (Throwable)unsupportedOperationException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sourceClosed(IReceiverChannel iReceiverChannel) {
        if (logger.isTraceEnabled()) {
            logger.trace("sourceClosed() - entry - source :" + iReceiverChannel);
        }
        Set<IReceiverChannel> set = this.openChannels;
        synchronized (set) {
            this.openChannels.remove(iReceiverChannel);
            this.open = this.openChannels.size() > 0 || !this.autoClose && !this.isClosing;
        }
        if (!this.isOpen()) {
            this.isClosing = false;
            this.queue.trigger();
            logger.debug("sourceClosed() - Message receiver closed");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("sourceClosed() - exit - Open = " + this.open);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sourceOpened(IReceiverChannel iReceiverChannel) {
        if (logger.isTraceEnabled()) {
            logger.trace("sourceOpened() - entry - source :" + iReceiverChannel);
        }
        Set<IReceiverChannel> set = this.openChannels;
        synchronized (set) {
            this.openChannels.add(iReceiverChannel);
            if (!this.open) {
                logger.debug("sourceOpened() - Message receiver opened");
            }
            this.open = true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("sourceOpened() - exit");
        }
    }
}

