/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message;

import com.isencia.message.IMessageProvider;
import com.isencia.message.ISenderChannel;
import com.isencia.message.ISenderChannelHandler;
import com.isencia.message.NoMoreMessagesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSenderChannelHandler
implements ISenderChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSenderChannelHandler.class);
    private ISenderChannel channel = null;
    private MessageLoop msgLoop = null;
    private boolean open = false;

    public DefaultSenderChannelHandler(ISenderChannel iSenderChannel) {
        this.channel = iSenderChannel;
    }

    @Override
    public void messageAvailable() {
        if (this.msgLoop != null) {
            this.msgLoop.trigger();
        } else {
            logger.error("messageAvailable() - Msg loop not initialized");
        }
    }

    @Override
    public void close() {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        if (this.isOpen()) {
            if (this.msgLoop != null) {
                this.msgLoop.interrupt();
                try {
                    logger.debug("close() - Joining msg loop...");
                    this.msgLoop.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.open = false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    @Override
    public void open() {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (!this.isOpen()) {
            this.open = true;
            this.msgLoop = new MessageLoop();
            this.msgLoop.start();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    class MessageLoop
    extends Thread {
        private int triggerCount = 0;

        MessageLoop() {
        }

        @Override
        public void run() {
            if (logger.isTraceEnabled()) {
                logger.trace("MessageLoop.run() - entry");
            }
            try {
                boolean bl = true;
                while (bl || !this.isInterrupted()) {
                    bl = false;
                    this.consumeTrigger();
                    for (IMessageProvider iMessageProvider : DefaultSenderChannelHandler.this.channel.getProviders()) {
                        boolean bl2 = false;
                        while (!bl2) {
                            try {
                                Object object = iMessageProvider.getMessage();
                                bl = true;
                                try {
                                    DefaultSenderChannelHandler.this.channel.sendMessage(object);
                                }
                                catch (Exception exception) {
                                    logger.error("Error sending message " + object, (Throwable)exception);
                                }
                            }
                            catch (NoMoreMessagesException noMoreMessagesException) {
                                bl2 = true;
                            }
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
            if (logger.isTraceEnabled()) {
                logger.trace("MessageLoop.run() - exit");
            }
        }

        public synchronized void trigger() {
            if (logger.isTraceEnabled()) {
                logger.trace("MessageLoop.trigger() - entry");
            }
            ++this.triggerCount;
            this.notifyAll();
            if (logger.isTraceEnabled()) {
                logger.trace("MessageLoop.trigger() - exit");
            }
        }

        public synchronized void consumeTrigger() throws InterruptedException {
            if (logger.isTraceEnabled()) {
                logger.trace("MessageLoop.consumeTrigger() - entry");
            }
            while (this.triggerCount <= 0) {
                this.wait();
            }
            --this.triggerCount;
            if (logger.isTraceEnabled()) {
                logger.trace("MessageLoop.consumeTrigger() - exit");
            }
        }
    }
}

