/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.sequence;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.internal.sequence.SequenceTrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class SequenceToArrayConverter
extends Transformer {
    private static Logger logger = LoggerFactory.getLogger(SequenceToArrayConverter.class);
    private Map sequences = new HashMap();

    public SequenceToArrayConverter(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doInitialize() - entry");
        }
        super.doInitialize();
        this.sequences.clear();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doInitialize() - exit");
        }
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - entry - message :" + managedMessage);
        }
        if (managedMessage.isPartOfSequence()) {
            SequenceTrace sequenceTrace = (SequenceTrace)this.sequences.get(managedMessage.getSequenceID());
            if (sequenceTrace == null) {
                sequenceTrace = new SequenceTrace(managedMessage.getSequenceID());
                this.sequences.put(sequenceTrace.getSequenceID(), sequenceTrace);
            }
            sequenceTrace.addMessage(managedMessage);
            if (sequenceTrace.isComplete()) {
                ManagedMessage managedMessage2 = null;
                try {
                    ManagedMessage[] managedMessageArray = sequenceTrace.getMessagesInSequence();
                    managedMessage2 = this.createMessage();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    int n = 0;
                    while (n < managedMessageArray.length) {
                        ManagedMessage managedMessage3 = managedMessageArray[n];
                        managedMessage2.addCauseID(managedMessage3.getID());
                        arrayList.add(managedMessage3.getBodyContent());
                        ++n;
                    }
                    managedMessage2.setBodyContent((Object)arrayList.toArray(), "application/java");
                    sequenceTrace.clear();
                    this.sequences.remove(sequenceTrace.getSequenceID());
                }
                catch (MessageException messageException) {
                    throw new ProcessingException("Error during processing of complete sequence", (Object)sequenceTrace, (Throwable)messageException);
                }
                this.sendOutputMsg(this.output, managedMessage2);
            }
        } else {
            this.sendOutputMsg(this.output, managedMessage);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - exit");
        }
    }

    protected String getExtendedInfo() {
        return "";
    }
}

