/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.net;

import com.isencia.message.ChannelException;
import com.isencia.message.IReceiverChannel;
import com.isencia.message.extractor.IMessageExtractor;
import com.isencia.message.net.SocketServerReceiverChannel;
import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.ChannelSource;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.gui.IOptionsFactory;
import com.isencia.passerelle.actor.net.SocketSvrRcvOptionsFactory;
import com.isencia.passerelle.core.PasserelleException;
import java.io.IOException;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class SocketServerReceiver
extends ChannelSource {
    private static Logger logger = LoggerFactory.getLogger(SocketServerReceiver.class);
    public Parameter socketPort = new Parameter((NamedObj)this, "port", (Token)new IntToken(this.getPort()));
    private int port = 3333;
    public Parameter msgExtractorType;
    static final String MSG_EXTRACTOR_PARAM_NAME = "Msg End";

    public SocketServerReceiver(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.socketPort.setTypeEquals((Type)BaseType.INT);
        this.msgExtractorType = new StringParameter((NamedObj)this, MSG_EXTRACTOR_PARAM_NAME);
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.socketPort) {
            IntToken intToken = (IntToken)this.socketPort.getToken();
            if (intToken != null && intToken.intValue() > 0) {
                this.setPort(intToken.intValue());
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return "localhost:" + this.getPort();
    }

    protected IReceiverChannel createChannel() throws ChannelException, InitializationException {
        IMessageExtractor iMessageExtractor = this.getExtractorFromSelectedOption();
        SocketServerReceiverChannel socketServerReceiverChannel = null;
        try {
            ServerSocket serverSocket = new ServerSocket(this.getPort());
            socketServerReceiverChannel = new SocketServerReceiverChannel(serverSocket, iMessageExtractor);
        }
        catch (IOException iOException) {
            throw new InitializationException(PasserelleException.Severity.FATAL, "Error opening server socket on port" + this.getPort(), (Object)this, (Throwable)iOException);
        }
        return socketServerReceiverChannel;
    }

    private IMessageExtractor getExtractorFromSelectedOption() throws InitializationException {
        IMessageExtractor iMessageExtractor = null;
        try {
            IOptionsFactory.Option option;
            if (this.getOptionsFactory() == null) {
                this.setOptionsFactory((IOptionsFactory)new SocketSvrRcvOptionsFactory((Actor)this, "_optionsFactory"));
            }
            if ((option = this.getOptionsFactory().getOption(this.msgExtractorType, this.msgExtractorType.getExpression())) == null) {
                option = this.getOptionsFactory().getDefaultOption(this.msgExtractorType);
            }
            iMessageExtractor = ((IMessageExtractor)option.getAssociatedObject()).cloneExtractor();
        }
        catch (Exception exception) {
            throw new InitializationException(PasserelleException.Severity.FATAL, "Error setting Parameter options factory", (Object)this, (Throwable)exception);
        }
        return iMessageExtractor;
    }
}

