/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.net;

import com.isencia.message.ChannelException;
import com.isencia.message.ISenderChannel;
import com.isencia.message.net.MulticastSenderChannel;
import com.isencia.passerelle.actor.ChannelSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class MulticastSender
extends ChannelSink {
    private static Logger logger = LoggerFactory.getLogger(MulticastSender.class);
    private int port = 4446;
    private String group = "230.0.0.1";
    public Parameter groupParam = new StringParameter((NamedObj)this, "group");
    public Parameter portParam;

    public MulticastSender(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.groupParam.setExpression(this.getGroup());
        this.portParam = new Parameter((NamedObj)this, "port", (Token)new IntToken(this.getPort()));
        this.portParam.setTypeEquals((Type)BaseType.INT);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    protected String getExtendedInfo() {
        return String.valueOf(this.getGroup()) + ":" + this.getPort();
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.portParam) {
            IntToken intToken = (IntToken)this.portParam.getToken();
            if (intToken != null && intToken.intValue() > 0) {
                this.setPort(intToken.intValue());
            }
        } else if (attribute == this.groupParam) {
            StringToken stringToken = (StringToken)this.groupParam.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                this.setGroup(stringToken.stringValue());
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected ISenderChannel createChannel() {
        MulticastSenderChannel multicastSenderChannel = null;
        try {
            multicastSenderChannel = new MulticastSenderChannel(this.getGroup(), this.getPort());
        }
        catch (ChannelException channelException) {
            logger.error("Error creating MulticastSenderChannel for " + this.getInfo(), (Throwable)channelException);
        }
        return multicastSenderChannel;
    }
}

