/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.mail;

import com.isencia.message.interceptor.IMessageInterceptor;
import com.isencia.passerelle.message.ManagedMessage;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageToMailMessageConverter
implements IMessageInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(MessageToMailMessageConverter.class);
    private boolean passThrough = false;

    public MessageToMailMessageConverter(boolean bl) {
        this.passThrough = bl;
    }

    public Object accept(Object object) throws Exception {
        String[] stringArray;
        if (logger.isTraceEnabled()) {
            logger.trace("Accepting ~" + object + "~");
        }
        ManagedMessage managedMessage = (ManagedMessage)object;
        logger.debug("Getting Mailhost");
        Properties properties = new Properties();
        String[] stringArray2 = managedMessage.getBodyHeader("MailHost");
        if (stringArray2 != null && stringArray2.length > 0 && stringArray2[0].length() > 0) {
            logger.debug("Mailhost : " + stringArray2[0]);
            properties.put("mail.host", stringArray2[0]);
        }
        Session session = Session.getDefaultInstance((Properties)properties, null);
        MimeMessage mimeMessage = new MimeMessage(session);
        logger.debug("Getting from addresses");
        String[] stringArray3 = managedMessage.getBodyHeader("From");
        if (stringArray3 != null && stringArray3.length > 0 && stringArray3[0].length() > 0) {
            logger.debug("From : " + stringArray3[0]);
            mimeMessage.setFrom((Address)new InternetAddress(stringArray3[0]));
        }
        logger.debug("Getting to addresses");
        String[] stringArray4 = managedMessage.getBodyHeader("To");
        if (stringArray4 != null && stringArray4.length > 0) {
            logger.debug("To addresses count : " + stringArray4.length);
            stringArray = new InternetAddress[stringArray4.length];
            int n = 0;
            while (n < stringArray4.length) {
                logger.debug("Send to : " + stringArray4[n]);
                stringArray[n] = new InternetAddress(stringArray4[n]);
                ++n;
            }
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])stringArray);
        }
        logger.debug("Getting cc addresses");
        stringArray = managedMessage.getBodyHeader("Cc");
        if (stringArray != null && stringArray.length > 0) {
            logger.debug("Cc addresses count : " + stringArray.length);
            InternetAddress[] internetAddressArray = new InternetAddress[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                logger.debug("Send cc : " + stringArray[n]);
                internetAddressArray[n] = new InternetAddress(stringArray[n]);
                ++n;
            }
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])internetAddressArray);
        }
        logger.debug("Getting bcc addresses");
        String[] stringArray5 = managedMessage.getBodyHeader("Bcc");
        if (stringArray5 != null && stringArray5.length > 0) {
            logger.debug("Bcc addresses count : " + stringArray5.length);
            InternetAddress[] internetAddressArray = new InternetAddress[stringArray5.length];
            int n = 0;
            while (n < stringArray5.length) {
                logger.debug("Send bcc : " + stringArray5[n]);
                internetAddressArray[n] = new InternetAddress(stringArray5[n]);
                ++n;
            }
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])internetAddressArray);
        }
        logger.debug("Getting subject");
        String[] stringArray6 = managedMessage.getBodyHeader("Subject");
        if (stringArray6 != null && stringArray6.length > 0 && stringArray6[0].length() > 0) {
            logger.debug("Set Subject : " + stringArray6[0]);
            mimeMessage.setSubject(stringArray6[0]);
        }
        if (this.passThrough) {
            mimeMessage.setText(managedMessage.toString());
        } else {
            Object object2 = managedMessage.getBodyContent();
            if (object2 instanceof Multipart) {
                mimeMessage.setContent((Multipart)((MimeMultipart)object2));
            } else if (object2 instanceof String) {
                String[] stringArray7 = managedMessage.getBodyHeader("Content-Type");
                if (stringArray7 == null || stringArray7.length == 0) {
                    mimeMessage.setText((String)object2);
                } else {
                    mimeMessage.setContent(object2, stringArray7[0]);
                }
            }
        }
        mimeMessage.saveChanges();
        if (logger.isTraceEnabled()) {
            logger.trace("exit");
        }
        return mimeMessage;
    }
}

