/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.mail;

import com.isencia.message.IReceiverChannel;
import com.isencia.message.interceptor.IMessageInterceptor;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import com.isencia.message.interceptor.MessageInterceptorChain;
import com.isencia.message.mail.MailReceiverChannel;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TriggeredChannelSource;
import com.isencia.passerelle.actor.mail.MailMessageToMessageConverter;
import com.isencia.passerelle.message.interceptor.IMessageCreator;
import com.isencia.passerelle.message.interceptor.TextToMessageConverter;
import java.util.Arrays;
import java.util.List;
import javax.mail.URLName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.gui.style.PasswordStyle;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class MailReceiver
extends TriggeredChannelSource {
    private static final String NOT_APPLICABLE = "N/A";
    private static Logger logger = LoggerFactory.getLogger(MailReceiver.class);
    private static final String[] protocolChoices = new String[]{"pop3", "imap"};
    private static final String[] msgTypeChoices = new String[]{"Messages", "Message Count"};
    private static final String[] msgStructChoices = new String[]{"Content", "Content & Attachments"};
    private static final String[] countTypeChoices = new String[]{"All", "Unread", "New"};
    private static final String[] contentTypeChoices = new String[]{"Text", "HTML", "All"};
    private static final List protocols = Arrays.asList(protocolChoices);
    private static final List msgTypes = Arrays.asList(msgTypeChoices);
    private static final List msgStructs = Arrays.asList(msgStructChoices);
    private static final List countTypes = Arrays.asList(countTypeChoices);
    private static final List contentTypes = Arrays.asList(contentTypeChoices);
    public static final int MESSAGETYPE_MESSAGE = 0;
    public static final int MESSAGETYPE_COUNT = 1;
    public static final int MESSAGETYPE_CONTENT = 0;
    public static final int MESSAGETYPE_CONTENT_ATTACHMENTS = 1;
    public static final int CONTENTTYPE_ALL = 0;
    public static final int CONTENTTYPE_TEXT = 1;
    public static final int CONTENTTYPE_HTML = 2;
    public static final int MESSAGECOUNTTYPE_ALL = 0;
    public static final int MESSAGECOUNTTYPE_UNREAD = 1;
    public static final int MESSAGECOUNTTYPE_NEW = 2;
    public static final String USER_PARAM = "User";
    public static final String PASSWORD_PARAM = "Password";
    public static final String HOST_PARAM = "Host";
    public static final String PROTOCOL_PARAM = "Protocol";
    public static final String MESSAGETYPE_PARAM = "What to Read";
    public static final String MESSAGESUBTYPE_PARAM = "Filter";
    public static final String CONTENTTYPE_PARAM = "Content Filter";
    public Parameter userParam;
    public Parameter passwordParam;
    public Parameter hostParam;
    public Parameter protocolParam;
    public Parameter messageTypeParam;
    public Parameter messageSubTypeParam;
    public Parameter contentTypeParam;
    private URLName server = null;
    private String user = "";
    private String password = "";
    private String host = "";
    private String protocol = protocolChoices[0];
    private boolean attachment = false;
    private boolean content = true;
    private int contentType = 0;
    private int messageType = 0;
    private int messageCountType = 0;

    public MailReceiver(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        String string2 = System.getProperty("mail.user", "");
        if (string2 == null || string2.length() == 0) {
            string2 = System.getProperty("user.name", "user");
        }
        this.userParam = new StringParameter((NamedObj)this, USER_PARAM);
        this.userParam.setExpression(string2);
        this.passwordParam = new StringParameter((NamedObj)this, PASSWORD_PARAM);
        new PasswordStyle((NamedObj)this.passwordParam, "_passwordStyle");
        this.hostParam = new StringParameter((NamedObj)this, HOST_PARAM);
        this.hostParam.setExpression(System.getProperty("mail.pop3.host", "your mail host"));
        this.protocolParam = new StringParameter((NamedObj)this, PROTOCOL_PARAM);
        this.protocolParam.setExpression((String)protocols.get(0));
        int n = 0;
        while (n < protocols.size()) {
            this.protocolParam.addChoice((String)protocols.get(n));
            ++n;
        }
        this.messageTypeParam = new StringParameter((NamedObj)this, MESSAGETYPE_PARAM);
        this.messageTypeParam.setExpression((String)msgTypes.get(0));
        n = 0;
        while (n < msgTypes.size()) {
            this.messageTypeParam.addChoice((String)msgTypes.get(n));
            ++n;
        }
        this.messageSubTypeParam = new StringParameter((NamedObj)this, MESSAGESUBTYPE_PARAM);
        this.messageSubTypeParam.setExpression((String)msgStructs.get(0));
        n = 0;
        while (n < msgStructs.size()) {
            this.messageSubTypeParam.addChoice((String)msgStructs.get(n));
            ++n;
        }
        this.contentTypeParam = new StringParameter((NamedObj)this, CONTENTTYPE_PARAM);
        this.contentTypeParam.setExpression((String)contentTypes.get(0));
        n = 0;
        while (n < contentTypes.size()) {
            this.contentTypeParam.addChoice((String)contentTypes.get(n));
            ++n;
        }
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.userParam) {
            StringToken stringToken = (StringToken)this.userParam.getToken();
            if (stringToken != null) {
                this.user = stringToken.stringValue();
                logger.debug("User changed to : " + this.user);
                this.setServerURL();
            }
        } else if (attribute == this.passwordParam) {
            StringToken stringToken = (StringToken)this.passwordParam.getToken();
            if (stringToken != null) {
                this.password = stringToken.stringValue();
                this.setServerURL();
            }
        } else if (attribute == this.hostParam) {
            StringToken stringToken = (StringToken)this.hostParam.getToken();
            if (stringToken != null) {
                this.host = stringToken.stringValue();
                logger.debug("Host changed to : " + this.host);
                this.setServerURL();
            }
        } else if (attribute == this.protocolParam) {
            String string = this.protocolParam.getExpression();
            String string2 = this.getProtocol();
            int n = protocols.indexOf(string);
            if (n < 0) {
                this.contentTypeParam.setExpression(string2);
            } else {
                this.setProtocol(string);
                logger.debug("Protocol changed to : " + string);
                this.setServerURL();
            }
        } else if (attribute == this.contentTypeParam) {
            if (this.getMessageType() == 0) {
                String string = this.contentTypeParam.getExpression();
                int n = this.getMessageType();
                int n2 = contentTypes.indexOf(string);
                if (n2 < 0) {
                    this.contentTypeParam.setExpression((String)contentTypes.get(n));
                } else {
                    this.setContentType(n2);
                    logger.debug("Content Type changed to : " + string);
                }
            } else {
                this.contentTypeParam.setExpression(NOT_APPLICABLE);
                this.setContentType(-1);
            }
        } else if (attribute == this.messageSubTypeParam) {
            String string = this.messageSubTypeParam.getExpression();
            int n = this.getMessageType();
            if (n == 0) {
                boolean bl;
                boolean bl2 = this.getAttachments();
                int n3 = contentTypes.indexOf(string);
                boolean bl3 = bl = n3 == 1;
                if (n3 < 0) {
                    this.messageSubTypeParam.setExpression((String)contentTypes.get(0));
                } else if (bl != bl2) {
                    this.setAttachments(bl);
                    logger.debug("Attachments changed to : " + bl);
                }
            } else if (n == 1) {
                int n4 = this.getMessageCountType();
                int n5 = countTypes.indexOf(string);
                if (n5 < 0) {
                    this.messageSubTypeParam.setExpression((String)countTypes.get(0));
                } else if (n5 != n4) {
                    this.setMessageCountType(n5);
                    logger.debug("CountType changed to : " + string);
                }
            }
        } else if (attribute == this.messageTypeParam) {
            String string = this.messageTypeParam.getExpression();
            int n = this.getMessageType();
            int n6 = msgTypes.indexOf(string);
            if (n6 < 0) {
                this.messageTypeParam.setExpression((String)msgTypes.get(n));
            } else if (n6 != n) {
                this.setMessageType(n6);
                logger.debug("MessageType changed to : " + string);
                if (n6 == 0) {
                    String string3 = this.messageSubTypeParam.getExpression();
                    String string4 = this.contentTypeParam.getExpression();
                    this.messageSubTypeParam.removeAllChoices();
                    int n7 = 0;
                    while (n7 < msgStructs.size()) {
                        this.messageSubTypeParam.addChoice((String)msgStructs.get(n7));
                        ++n7;
                    }
                    this.messageSubTypeParam.setExpression((String)msgStructs.get(0));
                    this.messageSubTypeParam.setExpression(string3);
                    this.contentTypeParam.removeAllChoices();
                    n7 = 0;
                    while (n7 < contentTypes.size()) {
                        this.contentTypeParam.addChoice((String)contentTypes.get(n7));
                        ++n7;
                    }
                    this.contentTypeParam.setExpression((String)contentTypes.get(0));
                    this.contentTypeParam.setExpression(string4);
                } else if (n6 == 1) {
                    String string5 = this.messageSubTypeParam.getExpression();
                    this.messageSubTypeParam.removeAllChoices();
                    int n8 = 0;
                    while (n8 < countTypes.size()) {
                        this.messageSubTypeParam.addChoice((String)countTypes.get(n8));
                        ++n8;
                    }
                    this.messageSubTypeParam.setExpression((String)countTypes.get(0));
                    this.messageSubTypeParam.setExpression(string5);
                    this.contentTypeParam.removeAllChoices();
                    this.contentTypeParam.addChoice(NOT_APPLICABLE);
                    this.contentTypeParam.setExpression("tmp");
                    this.contentTypeParam.setExpression(NOT_APPLICABLE);
                }
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    private void setServerURL() {
        this.server = new URLName(String.valueOf(this.getProtocol()) + "://" + this.user + ":" + this.password + "@" + this.host + "/INBOX");
    }

    protected IMessageInterceptorChain createInterceptorChain() {
        MessageInterceptorChain messageInterceptorChain = new MessageInterceptorChain();
        if (this.getMessageType() == 0) {
            MailMessageToMessageConverter mailMessageToMessageConverter = new MailMessageToMessageConverter();
            if (this.getContent()) {
                switch (this.contentType) {
                    case 1: {
                        mailMessageToMessageConverter.setContentTypes(new String[]{"text/plain"});
                        logger.debug("Content type filter set to text/plain");
                        break;
                    }
                    case 2: {
                        mailMessageToMessageConverter.setContentTypes(new String[]{"text/html"});
                        logger.debug("Content type filter set to text/html");
                        break;
                    }
                    case 0: {
                        mailMessageToMessageConverter.setContentTypes(new String[]{"text/plain", "text/html"});
                        logger.debug("Content type filter set to all");
                    }
                }
            } else {
                mailMessageToMessageConverter.setContentTypes(null);
            }
            messageInterceptorChain.add((IMessageInterceptor)mailMessageToMessageConverter);
        } else {
            messageInterceptorChain.add((IMessageInterceptor)new TextToMessageConverter((IMessageCreator)this));
        }
        return messageInterceptorChain;
    }

    protected boolean doPreFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        boolean bl = true;
        if (!this.getChannel().isOpen() && this.server == null) {
            this.requestFinish();
            bl = false;
        }
        if (bl) {
            bl = super.doPreFire();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " :" + bl);
        }
        return bl;
    }

    protected String getExtendedInfo() {
        return String.valueOf(this.user) + "@" + this.host;
    }

    public boolean getAttachments() {
        return this.attachment;
    }

    public boolean getContent() {
        return this.content;
    }

    public int getContentType() {
        return this.contentType;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setAttachments(boolean bl) {
        this.attachment = bl;
    }

    public void setContent(boolean bl) {
        this.content = bl;
    }

    public void setContentType(int n) {
        this.contentType = n;
    }

    public void setMessageType(int n) {
        this.messageType = n;
    }

    public int getMessageCountType() {
        return this.messageCountType;
    }

    public void setMessageCountType(int n) {
        this.messageCountType = n;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    protected IReceiverChannel createChannel() {
        MailReceiverChannel mailReceiverChannel = new MailReceiverChannel(this.server);
        if (this.getMessageType() == 0) {
            mailReceiverChannel.setMessageType(1);
        } else {
            switch (this.getMessageCountType()) {
                case 2: {
                    mailReceiverChannel.setMessageType(3);
                    break;
                }
                case 1: {
                    mailReceiverChannel.setMessageType(4);
                    break;
                }
                default: {
                    mailReceiverChannel.setMessageType(2);
                }
            }
        }
        return mailReceiverChannel;
    }
}

