/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.general;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.core.PortListener;
import com.isencia.passerelle.core.PortListenerAdapter;
import com.isencia.passerelle.message.ManagedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.LongToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class Counter
extends Transformer {
    private static final long serialVersionUID = 3712075950718358876L;
    private static Logger logger = LoggerFactory.getLogger(Counter.class);
    public Parameter startValueParam = new Parameter((NamedObj)this, "start", (Token)new LongToken(1L));
    private long startValue = 0L;
    private long value = 0L;
    public Port reset = null;
    private PortHandler resetHandler = null;
    private boolean isReset = true;

    public Counter(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.startValueParam.setTypeEquals((Type)BaseType.LONG);
        this.registerConfigurableParameter(this.startValueParam);
        this.reset = PortFactory.getInstance().createInputPort((Entity)this, "reset", null);
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        if (this.reset.getWidth() > 0) {
            this.resetHandler = new PortHandler((IOPort)this.reset, (PortListener)new PortListenerAdapter(){

                public void tokenReceived() {
                    Token token = Counter.this.resetHandler.getToken();
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(Counter.this.getInfo()) + " - Reset Event received");
                    }
                    if (token != null) {
                        Counter.this.isReset = true;
                    }
                }
            });
            this.resetHandler.start();
        }
        this.setValue(this.getStartValue());
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.startValueParam) {
            LongToken longToken = (LongToken)this.startValueParam.getToken();
            if (longToken != null) {
                this.setStartValue(longToken.longValue());
                logger.debug("Counter start value changed to : " + this.getStartValue());
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (this.isReset) {
            this.setValue(this.getStartValue());
            this.isReset = false;
        }
        ManagedMessage managedMessage2 = null;
        try {
            managedMessage2 = this.createMessage(Long.toString(this.value++), "text/plain");
        }
        catch (Exception exception) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + exception, (Object)managedMessage2, (Throwable)exception);
        }
        try {
            this.sendOutputMsg(this.output, managedMessage2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + illegalArgumentException, (Object)managedMessage2, (Throwable)illegalArgumentException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getAuditTrailMessage(ManagedMessage managedMessage, Port port) throws Exception {
        return "sent message with count " + managedMessage.getBodyContentAsString();
    }

    protected String getExtendedInfo() {
        return "";
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long l) {
        this.value = l;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public void setStartValue(long l) {
        this.startValue = l;
    }
}

