/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.general;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageHelper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class CommandExecutor
extends Actor {
    private static Logger logger = LoggerFactory.getLogger(CommandExecutor.class);
    public static final String COMMAND_HEADER = "Command";
    public static final String TRIGGER_PORT = "trigger";
    public static final String COMMAND_PARAMETER = "command";
    public static final String PARAMETERS_PARAMETER = "params";
    public Parameter commandParameter = new StringParameter((NamedObj)this, "command");
    public Parameter paramsParameter;
    public Port trigger = null;
    private PortHandler triggerHandler = null;
    private String defaultSourcePath = null;
    private boolean triggerConnected = false;

    public CommandExecutor(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.commandParameter.setExpression("");
        this.registerConfigurableParameter(this.commandParameter);
        this.paramsParameter = new StringParameter((NamedObj)this, PARAMETERS_PARAMETER);
        this.paramsParameter.setExpression("");
        this.registerConfigurableParameter(this.paramsParameter);
        this.trigger = PortFactory.getInstance().createInputPort((Entity)this, TRIGGER_PORT, null);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-9\" y1=\"-16\" x2=\"-12\" y2=\"-8\" style=\"stroke-width:2.0\"/>\n<line x1=\"-11\" y1=\"-7\" x2=\"-16\" y2=\"-7\" style=\"stroke-width:1.0\"/>\n<line x1=\"-13\" y1=\"-8\" x2=\"-15\" y2=\"-8\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-16\" y1=\"-7\" x2=\"-16\" y2=\"-5\" style=\"stroke-width:1.0\"/>\n<line x1=\"-11\" y1=\"-11\" x2=\"-8\" y2=\"-8\" style=\"stroke-width:1.5\"/>\n<line x1=\"-8\" y1=\"-8\" x2=\"-8\" y2=\"-6\" style=\"stroke-width:1.0\"/>\n<line x1=\"-8\" y1=\"-5\" x2=\"-6\" y2=\"-5\" style=\"stroke-width:1.0\"/>\n<line x1=\"-10\" y1=\"-14\" x2=\"-7\" y2=\"-11\" style=\"stroke-width:1.0\"/>\n<line x1=\"-7\" y1=\"-11\" x2=\"-5\" y2=\"-14\" style=\"stroke-width:1.0\"/>\n<line x1=\"-11\" y1=\"-14\" x2=\"-14\" y2=\"-14\" style=\"stroke-width:1.0\"/>\n<line x1=\"-14\" y1=\"-14\" x2=\"-12\" y2=\"-11\" style=\"stroke-width:1.0\"/>\n<rect x=\"-15\" y=\"-3\" width=\"28\" height=\"12\" style=\"fill:white;stroke-width:1.0;stroke:white\"/>\n<line x1=\"-14\" y1=\"-2\" x2=\"13\" y2=\"-2\" style=\"stroke-width:1.5;stroke:grey\"/>\n<line x1=\"-14\" y1=\"-2\" x2=\"-14\" y2=\"10\" style=\"stroke-width:1.5;stroke:grey\"/>\n<line x1=\"15\" y1=\"-2\" x2=\"15\" y2=\"11\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-15\" y1=\"11\" x2=\"15\" y2=\"11\" style=\"stroke-width:1.0;stroke:white\"/>\n<text x=\"-15\" y=\"5\" style=\"font-size:8\"> cmd </text>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.commandParameter || attribute == this.paramsParameter) {
            StringToken stringToken = (StringToken)this.commandParameter.getToken();
            StringToken stringToken2 = (StringToken)this.paramsParameter.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                String string = stringToken.stringValue();
                this.defaultSourcePath = String.valueOf(string) + " " + stringToken2.stringValue();
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doFire() throws ProcessingException {
        ManagedMessage managedMessage = null;
        String[] stringArray = null;
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (this.triggerConnected) {
            Token token;
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - Waiting for trigger");
            }
            if ((token = this.triggerHandler.getToken()) == null) {
                this.requestFinish();
            } else {
                try {
                    managedMessage = MessageHelper.getMessageFromToken((Token)token);
                }
                catch (PasserelleException passerelleException) {
                    throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated an exception while reading message", (Object)token, (Throwable)passerelleException);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Received msg :" + managedMessage);
                }
            }
        }
        if (!this.isFinishRequested()) {
            try {
                if (managedMessage != null && managedMessage.hasBodyHeader(COMMAND_HEADER)) {
                    stringArray = managedMessage.getBodyHeader(COMMAND_HEADER);
                }
            }
            catch (MessageException messageException) {
                logger.error("", (Throwable)messageException);
            }
            if (stringArray == null || stringArray.length == 0) {
                stringArray = new String[]{this.defaultSourcePath};
            }
            if (stringArray != null && stringArray.length > 0) {
                int n = 0;
                while (n < stringArray.length) {
                    try {
                        if (CommandExecutor.getAuditLogger().isInfoEnabled()) {
                            CommandExecutor.getAuditLogger().info("Executing " + stringArray[n]);
                        }
                        Runtime.getRuntime().exec(stringArray[n]);
                    }
                    catch (IOException iOException) {
                        logger.error("Unable to execute command : " + stringArray[n]);
                    }
                    ++n;
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        boolean bl = this.triggerConnected = this.trigger.getWidth() > 0;
        if (this.triggerConnected) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - Trigger(s) connected");
            }
            this.triggerHandler = new PortHandler((IOPort)this.trigger);
            this.triggerHandler.start();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected boolean doPostFire() throws ProcessingException {
        boolean bl;
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (bl = this.triggerConnected) {
            bl = super.doPostFire();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " :" + bl);
        }
        return bl;
    }

    protected String getExtendedInfo() {
        return this.defaultSourcePath;
    }
}

