/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.flow;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.core.PortListener;
import com.isencia.passerelle.core.PortListenerAdapter;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class Switch
extends Actor {
    private static Logger logger = LoggerFactory.getLogger(Switch.class);
    private List<Port> outputPorts = null;
    private PortHandler selectHandler = null;
    public Parameter numberOfOutputs = new Parameter((NamedObj)this, "count", (Token)new IntToken(1));
    public Port input;
    public Port select = null;
    private int outputCount = 0;
    private int selected = 0;

    public Switch(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.numberOfOutputs.setTypeEquals((Type)BaseType.INT);
        this.input = PortFactory.getInstance().createInputPort((Entity)this, null);
        this.input.setMultiport(false);
        this.select = PortFactory.getInstance().createInputPort((Entity)this, "select", Integer.class);
        this.input.setMultiport(false);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<circle cx=\"-2\" cy=\"-7\" r=\"4\"style=\"fill:black\"/>\n<line x1=\"-15\" y1=\"-5\" x2=\"15\" y2=\"-5\" style=\"stroke-width:2.0\"/>\n<line x1=\"0\" y1=\"-5\" x2=\"15\" y2=\"-15\" style=\"stroke-width:2.0\"/>\n<line x1=\"0\" y1=\"-5\" x2=\"15\" y2=\"5\" style=\"stroke-width:2.0\"/>\n<line x1=\"-15\" y1=\"10\" x2=\"0\" y2=\"10\" style=\"stroke-width:1.0;stroke:gray\"/>\n<line x1=\"0\" y1=\"10\" x2=\"0\" y2=\"-5\" style=\"stroke-width:1.0;stroke:gray\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.numberOfOutputs) {
            int n = ((IntToken)this.numberOfOutputs.getToken()).intValue();
            logger.debug("change number of outputs from :  " + this.outputCount + " to : " + n);
            if (this.outputPorts == null) {
                logger.debug("Create a new list");
                this.outputPorts = new ArrayList<Port>(5);
                int n2 = 0;
                while (n2 < n) {
                    try {
                        Port port = (Port)this.getPort("output " + n2);
                        if (port == null) {
                            port = PortFactory.getInstance().createOutputPort((Entity)this, "output " + n2);
                        }
                        this.outputPorts.add(n2, port);
                        logger.debug("created output : " + n2);
                    }
                    catch (NameDuplicationException nameDuplicationException) {
                        throw new IllegalActionException(nameDuplicationException.toString());
                    }
                    ++n2;
                }
            } else if (n < this.outputCount) {
                logger.debug("Decrement number of outputs");
                int n3 = this.outputCount - 1;
                while (n3 >= 0 && n3 >= n) {
                    try {
                        this.outputPorts.get(n3).setContainer(null);
                        this.outputPorts.remove(n3);
                        logger.debug("removed output : " + n3);
                    }
                    catch (NameDuplicationException nameDuplicationException) {
                        throw new IllegalActionException(nameDuplicationException.toString());
                    }
                    --n3;
                }
            } else if (n > this.outputCount) {
                logger.debug("Increment number of outputs");
                int n4 = this.outputCount;
                while (n4 < n) {
                    try {
                        Port port = (Port)this.getPort("output " + n4);
                        if (port == null) {
                            port = PortFactory.getInstance().createOutputPort((Entity)this, "output " + n4);
                        }
                        this.outputPorts.add(n4, port);
                        logger.debug("created output : " + n4);
                    }
                    catch (NameDuplicationException nameDuplicationException) {
                        throw new IllegalActionException(nameDuplicationException.toString());
                    }
                    ++n4;
                }
            }
            this.outputCount = n;
            if (this.selected >= this.outputCount) {
                this.selected = this.outputCount - 1;
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doFire() throws ProcessingException {
        int n = 0;
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        Token token = null;
        try {
            token = MessageHelper.getMessageAsToken((IOPort)this.input);
        }
        catch (PasserelleException passerelleException) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception in MessageHelper.getMessageAsToken() " + (Object)((Object)passerelleException), (Object)token, (Throwable)passerelleException);
        }
        if (token == null) {
            this.requestFinish();
        } else {
            n = this.selected;
            if (this.selected < 0) {
                n = 0;
                logger.debug(String.valueOf(this.getInfo()) + " : Selected port = " + this.selected + ". Using port " + n + ".");
            } else if (this.selected >= this.outputCount) {
                n = this.outputCount - 1;
                logger.debug(String.valueOf(this.getInfo()) + " : Selected port = " + this.selected + ". Using port " + n + ".");
            }
            try {
                this.outputPorts.get(n).broadcast(token);
            }
            catch (Exception exception) {
                throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception in outputPorts...broadcast() " + exception, (Object)token, (Throwable)exception);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " - Output " + n + " has sent message " + token);
        }
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        if (this.select.getWidth() > 0) {
            this.selectHandler = new PortHandler((IOPort)this.select, (PortListener)new PortListenerAdapter(){

                public void tokenReceived() {
                    Token token = Switch.this.selectHandler.getToken();
                    try {
                        ManagedMessage managedMessage = MessageHelper.getMessageFromToken((Token)token);
                        Switch.this.selected = ((Number)managedMessage.getBodyContent()).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (Exception exception) {
                        logger.error("", (Throwable)exception);
                    }
                    logger.debug("Event received : " + Switch.this.selected);
                }
            });
            this.selectHandler.start();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return String.valueOf(this.outputCount) + " output ports";
    }
}

