/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.flow;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.v5.Actor;
import com.isencia.passerelle.actor.v5.ActorContext;
import com.isencia.passerelle.actor.v5.ProcessRequest;
import com.isencia.passerelle.actor.v5.ProcessResponse;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.internal.MessageContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class RetryLoopActor
extends Actor {
    private final Logger logger = LoggerFactory.getLogger(RetryLoopActor.class);
    public Port input = PortFactory.getInstance().createInputPort((Entity)this, null);
    public Port retryOutput = PortFactory.getInstance().createOutputPort((Entity)this, "retryOutput");
    public Port noRetryOutput = PortFactory.getInstance().createOutputPort((Entity)this, "noRetryOutput");
    public Parameter retryCountParameter = new Parameter((NamedObj)this, "Max retry count", (Token)new IntToken(3));

    public RetryLoopActor(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<circle cx=\"0\" cy=\"0\" r=\"10\"style=\"fill:white;stroke-width:2.0\"/>\n<line x1=\"10\" y1=\"0\" x2=\"7\" y2=\"-3\" style=\"stroke-width:2.0\"/>\n<line x1=\"10\" y1=\"0\" x2=\"13\" y2=\"-3\" style=\"stroke-width:2.0\"/>\n</svg>\n");
    }

    protected void process(ActorContext actorContext, ProcessRequest processRequest, ProcessResponse processResponse) throws ProcessingException {
        MessageContainer messageContainer = (MessageContainer)processRequest.getMessage(this.input);
        String[] stringArray = messageContainer.getHeader(String.valueOf(this.getFullName()) + ".counter");
        int n = 0;
        if (stringArray != null && stringArray.length > 0) {
            String string = stringArray[0];
            try {
                n = Integer.parseInt(string) + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProcessingException("Invalid counter header value " + string, (Object)messageContainer, (Throwable)numberFormatException);
            }
        }
        messageContainer.setHeader(String.valueOf(this.getFullName()) + ".counter", Integer.toString(n));
        try {
            int n2 = ((IntToken)this.retryCountParameter.getToken()).intValue();
            if (n < n2) {
                processResponse.addOutputMessage(this.retryOutput, (ManagedMessage)messageContainer);
            } else {
                processResponse.addOutputMessage(this.noRetryOutput, (ManagedMessage)messageContainer);
            }
        }
        catch (IllegalActionException illegalActionException) {
            throw new ProcessingException("Error getting max counter value", (Object)messageContainer, (Throwable)illegalActionException);
        }
    }
}

