/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.filter;

import com.isencia.passerelle.actor.Filter;
import com.isencia.passerelle.actor.FilterException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class RegExpFilter
extends Filter {
    private static Logger logger = LoggerFactory.getLogger(RegExpFilter.class);
    public Parameter expressionParam = new StringParameter((NamedObj)this, "Expression");
    private Pattern pattern = null;

    public RegExpFilter(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.expressionParam.setExpression("");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.expressionParam) {
            String string = ((StringToken)this.expressionParam.getToken()).stringValue();
            try {
                this.pattern = Pattern.compile(string);
                logger.debug("Expression set to : " + string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new IllegalActionException("Invalid RegExp expression : " + string + " : " + patternSyntaxException.getMessage());
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected boolean isMatchingFilter(Object object) throws FilterException {
        boolean bl = false;
        if (this.pattern == null) {
            bl = true;
        } else if (object instanceof ManagedMessage) {
            ManagedMessage managedMessage = (ManagedMessage)object;
            Object[] objectArray = MessageHelper.getFilteredContent((ManagedMessage)managedMessage, (String[])new String[]{"text/plain", "text/html", "text/xml"});
            if (objectArray != null && objectArray.length > 0) {
                int n = 0;
                while (n < objectArray.length && !bl) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Content :" + objectArray[n]);
                    }
                    if (objectArray[n] instanceof String) {
                        bl = this.pattern.matcher((String)objectArray[n]).matches();
                    }
                    ++n;
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " : no valid content in " + object);
            }
        }
        return bl;
    }

    protected String getExtendedInfo() {
        return this.pattern.pattern();
    }
}

