/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.error;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.actor.v5.Actor;
import com.isencia.passerelle.actor.v5.ActorContext;
import com.isencia.passerelle.actor.v5.ProcessRequest;
import com.isencia.passerelle.actor.v5.ProcessResponse;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.ext.ErrorCollector;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class ErrorObserver
extends Actor
implements ErrorCollector {
    private static final Logger logger = LoggerFactory.getLogger(ErrorObserver.class);
    private BlockingQueue<PasserelleException> errors = new LinkedBlockingQueue<PasserelleException>();
    public Port errorOutput = PortFactory.getInstance().createOutputPort((Entity)this, "errorMsg");
    public Port errorTextOutput = PortFactory.getInstance().createOutputPort((Entity)this, "errorText");
    public Port messageInErrorOutput = PortFactory.getInstance().createOutputPort((Entity)this, "messageInError");

    public ErrorObserver(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:red;stroke:red\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<circle cx=\"0\" cy=\"0\" r=\"10\" style=\"fill:white;stroke-width:2.0\"/>\n<line x1=\"0\" y1=\"-15\" x2=\"0\" y2=\"0\" style=\"stroke-width:2.0\"/>\n<line x1=\"-3\" y1=\"-3\" x2=\"0\" y2=\"0\" style=\"stroke-width:2.0\"/>\n<line x1=\"3\" y1=\"-3\" x2=\"0\" y2=\"0\" style=\"stroke-width:2.0\"/>\n</svg>\n");
    }

    protected void doInitialize() throws InitializationException {
        super.doInitialize();
        try {
            ((Director)this.getDirector()).addErrorCollector((ErrorCollector)this);
        }
        catch (ClassCastException classCastException) {
            this.getLogger().info(String.valueOf(this.getInfo()) + " - used without Passerelle Director!!");
        }
        catch (Exception exception) {
            this.getLogger().error("Unexpected error while trying to register as error collector", (Throwable)exception);
        }
    }

    protected void process(ActorContext actorContext, ProcessRequest processRequest, ProcessResponse processResponse) throws ProcessingException {
        try {
            PasserelleException passerelleException = this.errors.poll(1L, TimeUnit.SECONDS);
            if (passerelleException != null) {
                this.sendOutErrorInfo(processResponse, passerelleException);
                this.drainErrorsQueueTo(processResponse);
            }
        }
        catch (InterruptedException interruptedException) {
            this.requestFinish();
        }
    }

    private void sendOutErrorInfo(ProcessResponse processResponse, PasserelleException passerelleException) throws ProcessingException {
        ManagedMessage managedMessage = this.createErrorMessage(passerelleException);
        processResponse.addOutputMessage(this.errorOutput, managedMessage);
        if (passerelleException.getContext() instanceof ManagedMessage) {
            ManagedMessage managedMessage2 = (ManagedMessage)passerelleException.getContext();
            processResponse.addOutputMessage(this.messageInErrorOutput, managedMessage2);
        }
        try {
            processResponse.addOutputMessage(this.errorTextOutput, this.createMessage(passerelleException.getMessage(), "text/plain"));
        }
        catch (MessageException messageException) {
            throw new ProcessingException("Error generating error text output", passerelleException.getContext(), (Throwable)messageException);
        }
    }

    private void drainErrorsQueueTo(ProcessResponse processResponse) throws ProcessingException {
        while (!this.errors.isEmpty()) {
            PasserelleException passerelleException = (PasserelleException)this.errors.poll();
            if (passerelleException == null) break;
            this.sendOutErrorInfo(processResponse, passerelleException);
        }
    }

    public void acceptError(PasserelleException passerelleException) {
        try {
            this.errors.put(passerelleException);
            this.getLogger().error("Error reported ", (Throwable)passerelleException);
        }
        catch (InterruptedException interruptedException) {
            this.getLogger().error("Receipt interrupted for ", (Throwable)passerelleException);
        }
    }

    protected void doWrapUp() throws TerminationException {
        try {
            ((Director)this.getDirector()).removeErrorCollector((ErrorCollector)this);
        }
        catch (ClassCastException classCastException) {}
        try {
            this.drainErrorsQueueTo(null);
        }
        catch (Exception exception) {
            throw new TerminationException(String.valueOf(this.getInfo()) + " - doWrapUp() generated exception " + exception, this.errors, (Throwable)exception);
        }
        super.doWrapUp();
    }

    protected Logger getLogger() {
        return logger;
    }
}

