/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.error;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.v5.ActorContext;
import com.isencia.passerelle.actor.v5.ProcessRequest;
import com.isencia.passerelle.actor.v5.ProcessResponse;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortMode;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.util.ExecutionTracerService;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ErrorGenerator
extends com.isencia.passerelle.actor.v5.Actor {
    public Parameter severityParam;
    public String severity = PasserelleException.Severity.FATAL.toString();
    public Port input;
    public Port output;
    public Parameter messageParam;
    public String message;
    public Parameter exceptionClassParam = new StringParameter((NamedObj)this, "Throwable class");
    public Throwable exception;

    public ErrorGenerator(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.exceptionClassParam.setExpression("java.lang.NullPointerException");
        this.messageParam = new StringParameter((NamedObj)this, "message");
        this.messageParam.setExpression("An error occured");
        this.severityParam = new StringParameter((NamedObj)this, "severity");
        this.severityParam.setExpression(this.severity);
        this.severityParam.addChoice(PasserelleException.Severity.FATAL.toString());
        this.severityParam.addChoice(PasserelleException.Severity.NON_FATAL.toString());
        this.input = PortFactory.getInstance().createInputPort((Entity)this, "in", null);
        this.input.setMode(PortMode.PUSH);
        this.output = PortFactory.getInstance().createOutputPort((Entity)this, "out");
    }

    protected void process(ActorContext actorContext, ProcessRequest processRequest, ProcessResponse processResponse) throws ProcessingException {
        ManagedMessage managedMessage = processRequest.getMessage(this.input);
        ExecutionTracerService.trace((Actor)this, (String)this.message);
        PasserelleException.Severity severity = PasserelleException.Severity.NON_FATAL;
        if (PasserelleException.Severity.FATAL.toString().equals(this.severity)) {
            severity = PasserelleException.Severity.FATAL;
        }
        throw new ProcessingException(severity, this.message, (Object)managedMessage, this.exception);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.messageParam) {
            this.message = ((StringToken)this.messageParam.getToken()).stringValue();
        } else if (attribute == this.severityParam) {
            this.severity = ((StringToken)this.severityParam.getToken()).stringValue();
        } else if (attribute == this.exceptionClassParam) {
            Class clazz = NullPointerException.class;
            String string = this.exceptionClassParam.getExpression();
            this.exception = null;
            try {
                clazz = Class.forName(string);
                this.exception = (Throwable)clazz.newInstance();
            }
            catch (Exception exception) {
                this.getLogger().warn("Error constructing exception instance for :" + string + " -- using NPE as default", (Throwable)exception);
                this.exception = new NullPointerException();
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    protected String getExtendedInfo() {
        return this.message;
    }
}

