/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.error;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.v5.Actor;
import com.isencia.passerelle.actor.v5.ActorContext;
import com.isencia.passerelle.actor.v5.ProcessRequest;
import com.isencia.passerelle.actor.v5.ProcessResponse;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.internal.ErrorMessageContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.gui.style.CheckBoxStyle;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ErrorCatcher
extends Actor {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ErrorCatcher.class);
    public Port input = PortFactory.getInstance().createInputPort((Entity)this, null);
    public Port output = PortFactory.getInstance().createOutputPort((Entity)this);
    public Parameter logReceivedMessages = new Parameter((NamedObj)this, "Log received messages", (Token)new BooleanToken(false));

    public ErrorCatcher(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.logReceivedMessages.setTypeEquals((Type)BaseType.BOOLEAN);
        new CheckBoxStyle(this.logReceivedMessages, "checkbox");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:white;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<rect x=\"-6\" y=\"-5\" width=\"12\" height=\"15\" style=\"fill:lightgrey;stroke:grey\"/>\n<line x1=\"-1\" y1=\"-9\" x2=\"1\" y2=\"-9\" style=\"stroke-width:2.0\"/>\n<line x1=\"-7\" y1=\"-7\" x2=\"7\" y2=\"-7\" style=\"stroke-width:1.0\"/>\n<line x1=\"-2\" y1=\"-5\" x2=\"-2\" y2=\"10\" style=\"stroke-width:1.0\"/>\n<line x1=\"2\" y1=\"-5\" x2=\"2\" y2=\"10\" style=\"stroke-width:1.0\"/>\n<line x1=\"-5\" y1=\"12\" x2=\"5\" y2=\"12\" style=\"stroke-width:2.0\"/>\n</svg>\n");
    }

    protected void process(ActorContext actorContext, ProcessRequest processRequest, ProcessResponse processResponse) throws ProcessingException {
        ManagedMessage managedMessage;
        ManagedMessage managedMessage2 = managedMessage = processRequest.getMessage(this.input);
        try {
            try {
                if (managedMessage instanceof ErrorMessageContainer) {
                    ErrorMessageContainer errorMessageContainer = (ErrorMessageContainer)managedMessage;
                    Object object = errorMessageContainer.getContext();
                    if (object != null && object instanceof ManagedMessage) {
                        managedMessage2 = (ManagedMessage)object;
                    }
                    if (((BooleanToken)this.logReceivedMessages.getToken()).booleanValue()) {
                        this.getLogger().info("Discarding error for context " + errorMessageContainer.getContext(), errorMessageContainer.getRootException());
                    }
                }
            }
            catch (IllegalActionException illegalActionException) {
                this.getLogger().error("Error reading parameter value", (Throwable)illegalActionException);
                processResponse.addOutputMessage(this.output, managedMessage2);
            }
        }
        finally {
            processResponse.addOutputMessage(this.output, managedMessage2);
        }
    }

    protected Logger getLogger() {
        return logger;
    }
}

