/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.eip;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.v5.Actor;
import com.isencia.passerelle.actor.v5.ActorContext;
import com.isencia.passerelle.actor.v5.ProcessRequest;
import com.isencia.passerelle.actor.v5.ProcessResponse;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.message.ManagedMessage;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public abstract class MessageFilter
extends Actor {
    public Port input = PortFactory.getInstance().createInputPort((Entity)this, null);
    public Port outputMatch = PortFactory.getInstance().createOutputPort((Entity)this, "match");
    public Port outputNoMatch = PortFactory.getInstance().createOutputPort((Entity)this, "noMatch");
    public StringParameter outputMatchPortNameParameter = new StringParameter((NamedObj)this, "Name for match output");
    public StringParameter outputNoMatchPortNameParameter;

    public MessageFilter(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.outputMatchPortNameParameter.setExpression(this.outputMatch.getName());
        this.outputNoMatchPortNameParameter = new StringParameter((NamedObj)this, "Name for noMatch output");
        this.outputNoMatchPortNameParameter.setExpression(this.outputNoMatch.getName());
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (this.outputMatchPortNameParameter == attribute) {
            this.outputMatch.setDisplayName(this.outputMatchPortNameParameter.getExpression());
            this.outputMatch.propagateValues();
        } else if (this.outputNoMatchPortNameParameter == attribute) {
            this.outputNoMatch.setDisplayName(this.outputNoMatchPortNameParameter.getExpression());
            this.outputNoMatch.propagateValues();
        } else {
            super.attributeChanged(attribute);
        }
    }

    protected void process(ActorContext actorContext, ProcessRequest processRequest, ProcessResponse processResponse) throws ProcessingException {
        ManagedMessage managedMessage = processRequest.getMessage(this.input);
        try {
            if (this.isMatchingFilter(managedMessage)) {
                processResponse.addOutputMessage(this.outputMatch, managedMessage);
            } else {
                processResponse.addOutputMessage(this.outputNoMatch, managedMessage);
            }
        }
        catch (ProcessingException processingException) {
            throw processingException;
        }
        catch (Exception exception) {
            throw new ProcessingException("Error matching filter for " + this.getFullName(), (Object)managedMessage, (Throwable)exception);
        }
    }

    protected abstract boolean isMatchingFilter(ManagedMessage var1) throws Exception;
}

