/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.dynaport;

import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public abstract class OutputPortBuilder
extends Attribute {
    private static Logger LOGGER = LoggerFactory.getLogger(OutputPortBuilder.class);
    private Set<String> outputPortNames = new HashSet<String>();
    private Set<String> outputPortNamesForContainerAccess = Collections.unmodifiableSet(this.outputPortNames);
    private Entity container;

    public OutputPortBuilder(Entity entity, String string) throws IllegalActionException, NameDuplicationException {
        super((NamedObj)entity, string);
        this.container = entity;
    }

    public Collection<String> getOutputPortNames() {
        return this.outputPortNamesForContainerAccess;
    }

    public List<Port> getOutputPorts() {
        ArrayList<Port> arrayList = new ArrayList<Port>();
        for (String string : this.outputPortNames) {
            Port port = (Port)this.container.getPort(string);
            if (port != null) {
                arrayList.add(port);
                continue;
            }
            LOGGER.error("{} - internal error - configured port not found with name {}", (Object)this.container.getFullName(), (Object)string);
        }
        return arrayList;
    }

    protected void changeOutputPorts(String string) {
        LOGGER.trace("{} - changeOutputPorts() - entry - portNames : {}", (Object)this.container.getFullName(), (Object)string);
        String[] stringArray = string.split(",");
        this.changeOutputPorts(stringArray);
        LOGGER.trace("{} - changeOutputPorts() - exit", (Object)this.container.getFullName());
    }

    protected void changeOutputPorts(String ... stringArray) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{} - changeOutputPorts() - entry - portNames : {}", (Object)this.container.getFullName(), (Object)Arrays.toString(stringArray));
        }
        HashSet<String> hashSet = new HashSet<String>(this.outputPortNames);
        this.outputPortNames.clear();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            Port port = (Port)this.container.getPort(string);
            if (port == null) {
                try {
                    this.createPort(string);
                }
                catch (IllegalActionException illegalActionException) {
                    LOGGER.error("{} - internal error - failed to create port with name {}", (Object)this.container.getFullName(), (Object)string);
                }
            }
            hashSet.remove(string);
            this.outputPortNames.add(string);
            ++n2;
        }
        for (String string : hashSet) {
            try {
                this.container.getPort(string).setContainer(null);
            }
            catch (Exception exception) {
                LOGGER.error("{} - internal error - failed to remove port with name {}", (Object)this.container.getFullName(), (Object)string);
            }
        }
        LOGGER.trace("{} - changeOutputPorts() - exit", (Object)this.container.getFullName());
    }

    protected Port createPort(String string) throws IllegalActionException {
        LOGGER.trace("{} - createPort() - entry - name : {}", (Object)this.container.getFullName(), (Object)string);
        Port port = null;
        try {
            port = (Port)this.container.getPort(string);
            if (port != null) {
                throw new IllegalActionException((Nameable)this.container, "port " + string + " already exists");
            }
            LOGGER.debug("{} - createPort() - port {} will be constructed", (Object)this.container.getFullName(), (Object)string);
            port = PortFactory.getInstance().createOutputPort(this.container, string);
            port.setMultiport(true);
        }
        catch (Exception exception) {
            throw new IllegalActionException((Nameable)this, (Throwable)exception, "failed to create port " + string);
        }
        LOGGER.trace("{} - createPort() - exit - port : {}", (Object)this.container.getFullName(), (Object)string);
        return port;
    }
}

