/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.dynaport;

import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class InputPortBuilder
extends Attribute {
    private static Logger LOGGER = LoggerFactory.getLogger(InputPortBuilder.class);
    private Set<String> inputPortNames = new HashSet<String>();
    private Set<String> inputPortNamesForContainerAccess = Collections.unmodifiableSet(this.inputPortNames);
    private Entity container;

    public InputPortBuilder(Entity entity, String string) throws IllegalActionException, NameDuplicationException {
        super((NamedObj)entity, string);
        this.container = entity;
    }

    public Collection<String> getInputPortNames() {
        return this.inputPortNamesForContainerAccess;
    }

    public List<Port> getInputPorts() {
        ArrayList<Port> arrayList = new ArrayList<Port>();
        for (String string : this.inputPortNames) {
            Port port = (Port)this.container.getPort(string);
            if (port != null) {
                arrayList.add(port);
                continue;
            }
            LOGGER.error("{} - internal error - configured port not found with name {}", (Object)this.container.getFullName(), (Object)string);
        }
        return arrayList;
    }

    protected void changeInputPorts(String string) {
        LOGGER.trace("{} - changeInputPorts() - entry - portNames : {}", (Object)this.container.getFullName(), (Object)string);
        String[] stringArray = string.split(",");
        this.changeInputPorts(stringArray);
        LOGGER.trace("{} - changeInputPorts() - exit", (Object)this.container.getFullName());
    }

    protected void changeInputPorts(String ... stringArray) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{} - changeInputPorts() - entry - portNames : {}", (Object)this.container.getFullName(), (Object)Arrays.toString(stringArray));
        }
        HashSet<String> hashSet = new HashSet<String>(this.inputPortNames);
        this.inputPortNames.clear();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            Port port = (Port)this.container.getPort(string);
            if (port == null) {
                try {
                    this.createPort(string);
                }
                catch (IllegalActionException illegalActionException) {
                    LOGGER.error("{} - internal error - failed to create port with name {}", (Object)this.container.getFullName(), (Object)string);
                }
            }
            hashSet.remove(string);
            this.inputPortNames.add(string);
            ++n2;
        }
        for (String string : hashSet) {
            try {
                this.container.getPort(string).setContainer(null);
            }
            catch (Exception exception) {
                LOGGER.error("{} - internal error - failed to remove port with name {}", (Object)this.container.getFullName(), (Object)string);
            }
        }
        LOGGER.trace("{} - changeInputPorts() - exit", (Object)this.container.getFullName());
    }

    protected Port createPort(String string) throws IllegalActionException {
        LOGGER.trace("{} - createPort() - entry - name : {}", (Object)this.container.getFullName(), (Object)string);
        Port port = null;
        try {
            port = (Port)this.container.getPort(string);
            if (port != null) {
                throw new IllegalActionException((Nameable)this.container, "port " + string + " already exists");
            }
            LOGGER.debug("{} - createPort() - port {} will be constructed", (Object)this.container.getFullName(), (Object)string);
            port = PortFactory.getInstance().createInputPort(this.container, string, PortMode.PUSH, null);
            port.setMultiport(true);
        }
        catch (Exception exception) {
            throw new IllegalActionException((Nameable)this, (Throwable)exception, "failed to create port " + string);
        }
        LOGGER.trace("{} - createPort() - exit - port : {}", (Object)this.container.getFullName(), (Object)string);
        return port;
    }
}

