/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.dynaport;

import com.isencia.passerelle.actor.v5.Actor;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortMode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public abstract class DynamicPortsActor
extends Actor {
    public static final String NUMBER_OF_INPUTS = "Number of inputs";
    public static final String NUMBER_OF_OUTPUTS = "Number of outputs";
    public static final String INPUTPORTPREFIX = "input";
    public static final String OUTPUTPORTPREFIX = "output";
    private static Logger logger = LoggerFactory.getLogger(DynamicPortsActor.class);
    public Parameter numberOfInputs = new Parameter((NamedObj)this, "Number of inputs", (Token)new IntToken(0));
    protected int nrInputPorts = 0;
    public Parameter numberOfOutputs = null;
    protected int nrOutputPorts = 0;

    public DynamicPortsActor(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.numberOfInputs.setTypeEquals((Type)BaseType.INT);
        this.numberOfOutputs = new Parameter((NamedObj)this, NUMBER_OF_OUTPUTS, (Token)new IntToken(0));
        this.numberOfOutputs.setTypeEquals((Type)BaseType.INT);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged() - entry - attribute :" + attribute);
        }
        if (attribute == this.numberOfOutputs) {
            int n = ((IntToken)this.numberOfOutputs.getToken()).intValue();
            if (n != this.nrOutputPorts) {
                this.changeNumberOfPorts(n, this.nrOutputPorts, PortType.OUTPUT);
                this.nrOutputPorts = n;
            }
        } else if (attribute == this.numberOfInputs) {
            int n = ((IntToken)this.numberOfInputs.getToken()).intValue();
            if (n != this.nrInputPorts) {
                this.changeNumberOfPorts(n, this.nrInputPorts, PortType.INPUT);
                this.nrInputPorts = n;
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged() - exit");
        }
    }

    public List<Port> getInputPorts() {
        ArrayList<Port> arrayList = new ArrayList<Port>();
        List list = this.inputPortList();
        for (Port port : list) {
            if (!port.getName().startsWith(INPUTPORTPREFIX, 0)) continue;
            arrayList.add(port);
        }
        return arrayList;
    }

    public int getNrInputPorts() {
        return this.nrInputPorts;
    }

    public int getNrOutputPorts() {
        return this.nrOutputPorts;
    }

    public List<Port> getOutputPorts() {
        ArrayList<Port> arrayList = new ArrayList<Port>();
        List list = this.outputPortList();
        for (Port port : list) {
            if (!port.getName().startsWith(OUTPUTPORTPREFIX, 0)) continue;
            arrayList.add(port);
        }
        return arrayList;
    }

    protected void changeNumberOfPorts(int n, int n2, PortType portType) throws IllegalActionException, IllegalArgumentException {
        String string;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " changeNumberOfPorts() - entry - portType : " + (Object)((Object)portType) + " / new nrOfPorts : " + n);
        }
        boolean bl = false;
        boolean bl2 = true;
        if (portType == PortType.INPUT) {
            bl = true;
            bl2 = false;
            string = INPUTPORTPREFIX;
        } else if (portType == PortType.OUTPUT) {
            bl = false;
            bl2 = true;
            string = OUTPUTPORTPREFIX;
        } else {
            throw new IllegalArgumentException("Unknown PortType: " + (Object)((Object)portType));
        }
        if (n < n2) {
            int n3 = n2 - 1;
            while (n3 >= 0 && n3 >= n) {
                String string2 = String.valueOf(string) + n3;
                try {
                    this.getPort(string2).setContainer(null);
                }
                catch (Exception exception) {
                    throw new IllegalActionException((Nameable)this, (Throwable)exception, "failed to remove port " + string2);
                }
                --n3;
            }
        } else if (n > n2) {
            int n4 = n2;
            while (n4 < n) {
                this.createPort(string, n4, bl, bl2);
                ++n4;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " changeNumberOfPorts() - exit");
        }
    }

    protected Port createPort(String string, int n, boolean bl, boolean bl2) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " createPort() - entry - name : " + string + " index : " + n);
        }
        Port port = null;
        String string2 = String.valueOf(string) + n;
        try {
            port = (Port)this.getPort(string2);
            if (port == null) {
                logger.debug(String.valueOf(this.getInfo()) + " createPort() - port " + string2 + " will be constructed");
                port = bl ? PortFactory.getInstance().createInputPort((Entity)this, string2, this.getPortModeForNewInputPort(string2), null) : PortFactory.getInstance().createOutputPort((Entity)this, string2);
                port.setMultiport(!bl);
            } else {
                logger.debug(String.valueOf(this.getInfo()) + " createPort() - port " + string2 + " already exists");
                port.setInput(bl);
                port.setOutput(bl2);
                port.setMode(this.getPortModeForNewInputPort(string2));
            }
        }
        catch (Exception exception) {
            throw new IllegalActionException((Nameable)this, (Throwable)exception, "failed to create port " + string2);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " createPort() - exit - port : " + port);
        }
        return port;
    }

    protected PortMode getPortModeForNewInputPort(String string) {
        return PortMode.PUSH;
    }

    protected static enum PortType {
        INPUT,
        OUTPUT;

    }
}

