/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.dynaport;

import com.isencia.passerelle.actor.v5.Actor;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public abstract class DynamicNamedInputPortsActor
extends Actor {
    public static final String INPUT_PORTNAMES = "Input port names (comma-separated)";
    private static Logger logger = LoggerFactory.getLogger(DynamicNamedInputPortsActor.class);
    public StringParameter inPortNamesParameter = null;
    public Set<String> inputPortNames = new HashSet<String>();

    public DynamicNamedInputPortsActor(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.inPortNamesParameter = new StringParameter((NamedObj)this, INPUT_PORTNAMES);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged() - entry - attribute :" + attribute);
        }
        if (attribute == this.inPortNamesParameter) {
            String string = this.inPortNamesParameter.getExpression();
            this.changeInputPorts(string);
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged() - exit");
        }
    }

    public List<Port> getInputPorts() {
        ArrayList<Port> arrayList = new ArrayList<Port>();
        for (String string : this.inputPortNames) {
            Port port = (Port)super.getPort(string);
            if (port != null) {
                arrayList.add(port);
                continue;
            }
            logger.error(String.valueOf(this.getInfo()) + " - internal error - configured port not found with name " + string);
        }
        return arrayList;
    }

    protected void changeInputPorts(String string) throws IllegalActionException, IllegalArgumentException {
        String[] stringArray;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " changeInputPorts() - entry - portNames : " + string);
        }
        Set<String> set = this.inputPortNames;
        this.inputPortNames = new HashSet<String>();
        String[] stringArray2 = stringArray = string.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            Port port = (Port)this.getPort(string2);
            if (port == null) {
                this.createPort(string2);
            }
            set.remove(string2);
            this.inputPortNames.add(string2);
            ++n2;
        }
        for (String string2 : set) {
            try {
                this.getPort(string2).setContainer(null);
            }
            catch (Exception exception) {
                throw new IllegalActionException((Nameable)this, (Throwable)exception, "failed to remove port " + string2);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " changeInputPorts() - exit");
        }
    }

    protected Port createPort(String string) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " createPort() - entry - name : " + string);
        }
        Port port = null;
        try {
            port = (Port)this.getPort(string);
            if (port != null) {
                throw new IllegalActionException((Nameable)this, "port " + string + " already exists");
            }
            logger.debug(String.valueOf(this.getInfo()) + " createPort() - port " + string + " will be constructed");
            port = PortFactory.getInstance().createInputPort((Entity)this, string, PortMode.PUSH, null);
            port.setMultiport(true);
        }
        catch (Exception exception) {
            throw new IllegalActionException((Nameable)this, (Throwable)exception, "failed to create port " + string);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " createPort() - exit - port : " + port);
        }
        return port;
    }
}

