/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.control;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.core.PortListener;
import com.isencia.passerelle.core.PortListenerAdapter;
import com.isencia.passerelle.message.ManagedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class Timer
extends Actor {
    private static Logger logger = LoggerFactory.getLogger(Timer.class);
    private boolean setPresent = false;
    private boolean set = false;
    private boolean reset = false;
    private Parameter timeParameter = new Parameter((NamedObj)this, "time", (Token)new IntToken(10));
    private Port setInputPort = null;
    private Port resetInputPort = null;
    private Port outputPort = null;
    private int time = 0;
    private PortHandler setHandler = null;
    private PortHandler resetHandler = null;

    public Timer(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.timeParameter.setTypeEquals((Type)BaseType.INT);
        this.registerConfigurableParameter(this.timeParameter);
        this.setInputPort = PortFactory.getInstance().createInputPort((Entity)this, "set", null);
        this.resetInputPort = PortFactory.getInstance().createInputPort((Entity)this, "reset", null);
        this.outputPort = PortFactory.getInstance().createOutputPort((Entity)this, "output");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<circle cx=\"0\" cy=\"0\" r=\"16\"style=\"fill:white\"/>\n<line x1=\"0\" y1=\"-14\" x2=\"0\" y2=\"-12\"/>\n<line x1=\"0\" y1=\"12\" x2=\"0\" y2=\"14\"/>\n<line x1=\"-14\" y1=\"0\" x2=\"-12\" y2=\"0\"/>\n<line x1=\"12\" y1=\"0\" x2=\"14\" y2=\"0\"/>\n<line x1=\"0\" y1=\"-7\" x2=\"0\" y2=\"0\"/>\n<line x1=\"0\" y1=\"0\" x2=\"11.26\" y2=\"-6.5\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.timeParameter) {
            this.time = ((IntToken)this.timeParameter.getToken()).intValue() * 1000;
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        if (this.setInputPort.getWidth() > 0) {
            this.setHandler = new PortHandler((IOPort)this.setInputPort, (PortListener)new PortListenerAdapter(){

                public void tokenReceived() {
                    Token token;
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(Timer.this.getInfo()) + " - Set Event received");
                    }
                    if ((token = Timer.this.setHandler.getToken()) != null) {
                        Timer.this.set = true;
                        Timer.this.performNotify();
                    }
                }
            });
            if (this.setHandler != null) {
                this.setPresent = true;
                this.setHandler.start();
            }
        }
        if (this.resetInputPort.getWidth() > 0) {
            this.resetHandler = new PortHandler((IOPort)this.resetInputPort, (PortListener)new PortListenerAdapter(){

                public void tokenReceived() {
                    Token token = Timer.this.resetHandler.getToken();
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(Timer.this.getInfo()) + " - Reset Event received");
                    }
                    if (token != null) {
                        Timer.this.reset = true;
                        Timer.this.performNotify();
                    }
                }
            });
            if (this.resetHandler != null) {
                this.resetHandler.start();
            }
        }
    }

    private synchronized void performNotify() {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        ((Object)((Object)this)).notify();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    private synchronized void performWait(int n) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + n);
        }
        try {
            if (n == -1) {
                ((Object)((Object)this)).wait();
            } else {
                ((Object)((Object)this)).wait(n);
            }
        }
        catch (InterruptedException interruptedException) {
            this.requestFinish();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (!this.setPresent) {
            this.performWait(this.time);
            if (this.reset || this.isFinishRequested()) {
                this.reset = false;
                return;
            }
        } else {
            this.isFiring = false;
            while (!this.set && !this.isFinishRequested()) {
                this.performWait(-1);
            }
            if (this.isFinishRequested()) {
                return;
            }
            this.isFiring = true;
            this.set = false;
            this.performWait(this.time);
            if (this.reset || this.isFinishRequested()) {
                this.reset = false;
                return;
            }
        }
        ManagedMessage managedMessage = this.createTriggerMessage();
        try {
            managedMessage.setBodyContent((Object)Long.toString(this.time), "text/plain");
        }
        catch (Exception exception) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + exception, (Object)managedMessage, (Throwable)exception);
        }
        try {
            this.sendOutputMsg(this.outputPort, managedMessage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + illegalArgumentException, (Object)managedMessage, (Throwable)illegalArgumentException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getAuditTrailMessage(ManagedMessage managedMessage, Port port) {
        return "generated timed trigger.";
    }

    protected String getExtendedInfo() {
        return "period: " + this.time + " s";
    }

    protected void doStopFire() {
        this.performNotify();
    }
}

