/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.views.monitor;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.dawb.common.ui.Activator;
import org.dawb.common.ui.views.monitor.HardwareObject;
import org.dawb.common.ui.views.monitor.HardwareObjectEvent;
import org.dawb.common.ui.views.monitor.HardwareObjectListener;
import org.dawb.common.ui.views.monitor.MonitorUtils;
import org.dawb.common.ui.widgets.DoubleClickModifier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitorView
extends ViewPart
implements HardwareObjectListener {
    private static final Logger logger = LoggerFactory.getLogger(MonitorView.class);
    private transient BlockingQueue<HardwareObject> updateQueue = new LinkedBlockingQueue<HardwareObject>(5);
    private Thread notifyQueueThread;
    public static final String ID = "org.dawb.common.ui.views.dashboardView";
    private TableViewer serverViewer;
    private TableViewerColumn maxColumn;
    private TableViewerColumn minColumn;
    private TableViewerColumn desColumn;
    private List<HardwareObject> data;

    public void createPartControl(Composite composite) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite composite2 = new Composite((Composite)scrolledComposite, 0);
        composite2.setLayout((Layout)new FillLayout());
        scrolledComposite.setContent((Control)composite2);
        this.serverViewer = new TableViewer(composite2, 2820);
        this.serverViewer.getTable().setLinesVisible(true);
        this.serverViewer.getTable().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.serverViewer, (int)2);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.serverViewer, 0);
        tableViewerColumn.getColumn().setText("Name");
        tableViewerColumn.getColumn().setWidth(150);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new TableLabelProvider(0));
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.serverViewer, 0);
        tableViewerColumn2.getColumn().setText("Value");
        tableViewerColumn2.getColumn().setWidth(150);
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new TableLabelProvider(1));
        this.minColumn = new TableViewerColumn(this.serverViewer, 0);
        this.minColumn.getColumn().setText("Minimum");
        this.minColumn.getColumn().setWidth(150);
        this.minColumn.setLabelProvider((CellLabelProvider)new TableLabelProvider(2));
        this.maxColumn = new TableViewerColumn(this.serverViewer, 0);
        this.maxColumn.getColumn().setText("Maximum");
        this.maxColumn.getColumn().setWidth(150);
        this.maxColumn.setLabelProvider((CellLabelProvider)new TableLabelProvider(3));
        this.desColumn = new TableViewerColumn(this.serverViewer, 0);
        this.desColumn.getColumn().setText("Description");
        this.desColumn.getColumn().setWidth(150);
        this.desColumn.setLabelProvider((CellLabelProvider)new TableLabelProvider(4));
        this.serverViewer.setColumnProperties(new String[]{"Object Name", "Object Value"});
        this.serverViewer.setCellEditors(this.createCellEditors(this.serverViewer));
        this.serverViewer.setCellModifier(this.createModifier(this.serverViewer));
        this.createContentProvider();
        this.serverViewer.setInput(new Object());
        this.getSite().setSelectionProvider((ISelectionProvider)this.serverViewer);
        this.createRightClickMenu();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("org.dawb.dashboard.format")) {
                    MonitorView.this.serverViewer.refresh();
                } else if (propertyChangeEvent.getProperty().equals("org.dawb.dashboard.bounds")) {
                    MonitorView.this.updateBoundsColumns();
                } else if (propertyChangeEvent.getProperty().equals("org.dawb.dashboard.dummy")) {
                    MonitorView.this.updateDummyColumn();
                } else if (propertyChangeEvent.getProperty().equals("org.dawb.remote.session.mock")) {
                    MonitorView.this.refresh();
                }
            }
        });
        this.updateBoundsColumns();
        this.updateDummyColumn();
    }

    private void updateBoundsColumns() {
        boolean bl = Activator.getDefault().getPreferenceStore().getBoolean("org.dawb.dashboard.bounds");
        if (!bl) {
            this.maxColumn.getColumn().setWidth(0);
            this.maxColumn.getColumn().setResizable(false);
            this.minColumn.getColumn().setWidth(0);
            this.minColumn.getColumn().setResizable(false);
        } else {
            this.maxColumn.getColumn().setWidth(150);
            this.maxColumn.getColumn().setResizable(true);
            this.minColumn.getColumn().setWidth(150);
            this.minColumn.getColumn().setResizable(true);
        }
    }

    private void updateDummyColumn() {
        boolean bl = Activator.getDefault().getPreferenceStore().getBoolean("org.dawb.dashboard.dummy");
        if (!bl) {
            this.desColumn.getColumn().setWidth(0);
            this.desColumn.getColumn().setResizable(false);
        } else {
            this.desColumn.getColumn().setWidth(150);
            this.desColumn.getColumn().setResizable(true);
        }
    }

    private void createRightClickMenu() {
        MenuManager menuManager = new MenuManager();
        this.serverViewer.getControl().setMenu(menuManager.createContextMenu(this.serverViewer.getControl()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.serverViewer);
    }

    private CellEditor[] createCellEditors(TableViewer tableViewer) {
        CellEditor[] cellEditorArray = new CellEditor[1];
        TextCellEditor textCellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        ((Text)textCellEditor.getControl()).setTextLimit(60);
        cellEditorArray[0] = textCellEditor;
        return cellEditorArray;
    }

    private ICellModifier createModifier(TableViewer tableViewer) {
        return new DoubleClickModifier((ColumnViewer)tableViewer){

            @Override
            public boolean canModify(Object object, String string) {
                if (!this.enabled) {
                    return false;
                }
                return object instanceof HardwareObject && "Object Name".equalsIgnoreCase(string);
            }

            public Object getValue(Object object, String string) {
                String string2 = ((HardwareObject)object).getHardwareName();
                return string2 != null ? string2 : "";
            }

            public void modify(Object object, String string, Object object2) {
                block5: {
                    try {
                        try {
                            HardwareObject hardwareObject = (HardwareObject)((IStructuredSelection)MonitorView.this.serverViewer.getSelection()).getFirstElement();
                            hardwareObject.setHardwareName((String)object2);
                            hardwareObject.connect();
                        }
                        catch (Exception exception) {
                            logger.error("Cannot set " + string, (Throwable)exception);
                            this.setEnabled(false);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        this.setEnabled(false);
                        throw throwable;
                    }
                    this.setEnabled(false);
                }
                MonitorView.this.serverViewer.refresh();
            }
        };
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite);
        try {
            if (iMemento != null) {
                this.data = this.getDataFromXML(iMemento.getTextData());
            }
            if (this.data == null) {
                this.data = this.getDefaultServerObjects();
            }
            this.connect();
        }
        catch (Exception exception) {
            throw new PartInitException(exception.getMessage());
        }
    }

    private void connect() {
        Job job = new Job("Connecting dashboard to objects..."){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                for (HardwareObject hardwareObject : MonitorView.this.data) {
                    try {
                        try {
                            hardwareObject.connect();
                        }
                        catch (Exception exception) {
                            logger.debug("Dashboard view error while trying to connect", (Throwable)exception);
                            hardwareObject.addServerObjectListener(MonitorView.this);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        hardwareObject.addServerObjectListener(MonitorView.this);
                        throw throwable;
                    }
                    hardwareObject.addServerObjectListener(MonitorView.this);
                }
                if (MonitorView.this.serverViewer != null && !MonitorView.this.serverViewer.getTable().isDisposed()) {
                    MonitorView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MonitorView.this.serverViewer.refresh();
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(40);
        job.setUser(false);
        job.schedule();
    }

    private void disconnect() {
        for (HardwareObject hardwareObject : this.data) {
            hardwareObject.disconnect();
        }
        for (HardwareObject hardwareObject : this.data) {
            hardwareObject.removeServerObjectListener(this);
        }
    }

    public void saveState(IMemento iMemento) {
        try {
            iMemento.putTextData(this.getXMLFromData(this.data));
        }
        catch (Exception exception) {
            logger.error("Cannot save plot bean", (Throwable)exception);
        }
    }

    private List<HardwareObject> getDataFromXML(String string) throws Exception {
        if (string == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(MonitorUtils.createHardwareObject().getClass().getClassLoader());
            XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(byteArrayInputStream));
            List list = (List)xMLDecoder.readObject();
            xMLDecoder.close();
            List list2 = list;
            return list2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private String getXMLFromData(List<HardwareObject> list) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(MonitorUtils.createHardwareObject().getClass().getClassLoader());
            XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(byteArrayOutputStream));
            xMLEncoder.writeObject(list);
            xMLEncoder.close();
            String string = byteArrayOutputStream.toString("UTF-8");
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Override
    public void hardwareObjectChangePerformed(HardwareObjectEvent hardwareObjectEvent) {
        if (this.serverViewer.getTable().isDisposed()) {
            return;
        }
        if (this.serverViewer.isCellEditorActive()) {
            return;
        }
        this.createNotifyQueue();
        HardwareObject hardwareObject = (HardwareObject)hardwareObjectEvent.getSource();
        Iterator iterator = this.updateQueue.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != hardwareObject) continue;
            iterator.remove();
        }
        this.updateQueue.add(hardwareObject);
    }

    private void createNotifyQueue() {
        if (this.notifyQueueThread != null) {
            return;
        }
        this.notifyQueueThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HardwareObject hardwareObject;
                    while ((hardwareObject = (HardwareObject)MonitorView.this.updateQueue.take()) != HardwareObject.NULL) {
                        MonitorView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (MonitorView.this.serverViewer == null || MonitorView.this.serverViewer.getControl().isDisposed()) {
                                    return;
                                }
                                MonitorView.this.serverViewer.update((Object)hardwareObject, null);
                            }
                        });
                        Thread.sleep(200L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    logger.error("Cannot monitor events!", (Throwable)interruptedException);
                }
                logger.debug("Stopping thread '" + Thread.currentThread().getName() + "'");
            }
        }, String.valueOf(this.getPartName()) + " Thread");
        this.notifyQueueThread.start();
    }

    public void dispose() {
        super.dispose();
        this.disconnect();
        this.data.clear();
        this.updateQueue.clear();
        this.updateQueue.add(HardwareObject.NULL);
        this.serverViewer.getTable().dispose();
        this.serverViewer = null;
    }

    public void addServerObject(HardwareObject hardwareObject) {
        try {
            hardwareObject.connect();
            this.data.add(hardwareObject);
            hardwareObject.addServerObjectListener(this);
            this.serverViewer.refresh();
            ((DoubleClickModifier)this.serverViewer.getCellModifier()).setEnabled(true);
            this.serverViewer.editElement((Object)hardwareObject, 0);
        }
        catch (Exception exception) {
            logger.error("Cannot add object", (Throwable)exception);
        }
    }

    public void deleteSelectedObject() {
        try {
            HardwareObject hardwareObject = (HardwareObject)((IStructuredSelection)this.serverViewer.getSelection()).getFirstElement();
            this.data.remove(hardwareObject);
            hardwareObject.disconnect();
            this.serverViewer.refresh();
        }
        catch (Exception exception) {}
    }

    public void resetSelectedObjects() {
        try {
            this.disconnect();
            this.data.clear();
            this.data.addAll(this.getDefaultServerObjects());
            this.connect();
        }
        catch (Exception exception) {
            logger.error("Cannot reset objects", (Throwable)exception);
        }
    }

    public void refresh() {
        try {
            this.disconnect();
            this.connect();
        }
        catch (Exception exception) {
            logger.error("Cannot refresh objects", (Throwable)exception);
        }
    }

    public void move(int n) {
        int n2 = this.serverViewer.getTable().getSelectionIndex();
        int n3 = n2 + n;
        if (n3 < 0 || n3 > this.data.size() - 1) {
            return;
        }
        HardwareObject hardwareObject = this.data.remove(n2);
        this.data.add(n3, hardwareObject);
        this.serverViewer.refresh();
    }

    public void clearSelectedObjects() {
        boolean bl = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Please confirm clear", (String)"Would you like to clear all monitored objects?");
        if (!bl) {
            return;
        }
        try {
            this.disconnect();
            this.data.clear();
            this.serverViewer.refresh();
        }
        catch (Exception exception) {
            logger.error("Cannot clear objects", (Throwable)exception);
        }
    }

    private void createContentProvider() {
        this.serverViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                return MonitorView.this.data.toArray();
            }
        });
    }

    public void setFocus() {
        if (this.serverViewer != null) {
            this.serverViewer.getControl().setFocus();
        }
    }

    protected List<HardwareObject> getDefaultServerObjects() throws Exception {
        ArrayList<HardwareObject> arrayList = new ArrayList<HardwareObject>(5);
        return arrayList;
    }

    private class TableLabelProvider
    extends ColumnLabelProvider {
        private int column;

        TableLabelProvider(int n) {
            this.column = n;
        }

        public String getText(Object object) {
            HardwareObject hardwareObject = (HardwareObject)object;
            switch (this.column) {
                case 0: {
                    return hardwareObject.getLabel();
                }
                case 1: {
                    return this.formatValue(hardwareObject.getValue(), hardwareObject.getUnit());
                }
                case 2: {
                    return this.formatValue(hardwareObject.getMinimum(), hardwareObject.getUnit());
                }
                case 3: {
                    return this.formatValue(hardwareObject.getMaximum(), hardwareObject.getUnit());
                }
                case 4: {
                    return hardwareObject.getDescription();
                }
            }
            return "";
        }

        private String formatValue(Object object, String string) {
            Object object2 = object;
            if (object2 != null) {
                try {
                    double d = object2 instanceof Double ? (Double)object2 : Double.parseDouble(object2.toString());
                    String string2 = Activator.getDefault().getPreferenceStore().getString("org.dawb.dashboard.format");
                    DecimalFormat decimalFormat = new DecimalFormat(string2);
                    object2 = decimalFormat.format(d);
                }
                catch (Exception exception) {
                    object2 = object;
                }
            }
            if (object2 != null && string != null) {
                return object2 + " " + string;
            }
            if (object2 != null) {
                return "" + object2;
            }
            return "";
        }

        public String getToolTipText(Object object) {
            HardwareObject hardwareObject = (HardwareObject)object;
            if (hardwareObject.isError()) {
                return "Cannot locate scannable '" + hardwareObject.getLabel() + "'.";
            }
            if (this.column == 4) {
                return hardwareObject.getClassName();
            }
            return hardwareObject.getTooltip();
        }
    }
}

