/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.views.monitor;

import java.text.DecimalFormat;
import org.dawb.common.ui.Activator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MonitorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.dawb.common.ui.views.dashboard.dashboardPreferences";
    private StringFieldEditor formatFieldEditor;

    public MonitorPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Preferences for the dashboard view such as the format for the values and bounds and visibility controls.");
    }

    protected void createFieldEditors() {
        this.formatFieldEditor = new StringFieldEditor("org.dawb.dashboard.format", "Dashboard number format", this.getFieldEditorParent());
        this.addField((FieldEditor)this.formatFieldEditor);
        BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor("org.dawb.dashboard.bounds", "Show bounds", this.getFieldEditorParent());
        this.addField((FieldEditor)booleanFieldEditor);
        BooleanFieldEditor booleanFieldEditor2 = new BooleanFieldEditor("org.dawb.dashboard.dummy", "Show description", this.getFieldEditorParent());
        this.addField((FieldEditor)booleanFieldEditor2);
    }

    protected void checkState() {
        super.checkState();
        try {
            DecimalFormat decimalFormat = new DecimalFormat(this.formatFieldEditor.getStringValue());
            decimalFormat.format(100.001);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setErrorMessage("The format '" + this.formatFieldEditor.getStringValue() + "' is not valid.");
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    public void init(IWorkbench iWorkbench) {
    }
}

