/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.views.monitor;

import java.util.HashSet;
import java.util.Set;
import org.dawb.common.ui.views.monitor.HardwareObjectEvent;
import org.dawb.common.ui.views.monitor.HardwareObjectListener;

public abstract class HardwareObject {
    public static final HardwareObject NULL = new HardwareObject(){

        @Override
        protected void connect() throws Exception {
        }

        @Override
        protected void disconnect() {
        }
    };
    protected transient Set<HardwareObjectListener> listeners;
    protected volatile transient Object value;
    protected transient Object maximum;
    protected transient Object minimum;
    protected String hardwareName;
    protected String tooltip;
    protected String label;
    protected String unit;
    protected boolean error;
    protected String className;
    protected String description;

    protected abstract void connect() throws Exception;

    protected abstract void disconnect();

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public Object getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public void addServerObjectListener(HardwareObjectListener hardwareObjectListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<HardwareObjectListener>(7);
        }
        this.listeners.add(hardwareObjectListener);
    }

    public void removeServerObjectListener(HardwareObjectListener hardwareObjectListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(hardwareObjectListener);
    }

    protected void notifyServerObjectListeners(HardwareObjectEvent hardwareObjectEvent) {
        for (HardwareObjectListener hardwareObjectListener : this.listeners) {
            hardwareObjectListener.hardwareObjectChangePerformed(hardwareObjectEvent);
        }
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String string) {
        this.tooltip = string;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean bl) {
        this.error = bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.label == null ? 0 : this.label.hashCode());
        return n;
    }

    public Object getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Object object) {
        this.maximum = object;
    }

    public Object getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Object object) {
        this.minimum = object;
    }

    protected String getClassName() {
        return this.className;
    }

    protected void setClassName(String string) {
        this.className = string;
    }

    protected String getDescription() {
        return this.description;
    }

    protected void setDescription(String string) {
        this.description = string;
    }

    public String getHardwareName() {
        return this.hardwareName;
    }

    public void setHardwareName(String string) {
        this.hardwareName = string;
    }
}

