/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.views;

import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.dawb.common.services.IThumbnailService;
import org.dawb.common.services.ServiceManager;
import org.dawb.common.ui.Activator;
import org.dawb.common.ui.menu.CheckableActionGroup;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.views.GallerySelectionProvider;
import org.dawb.common.ui.views.ImageItem;
import org.dawb.common.util.image.ImageFileUtils;
import org.dawb.common.util.io.FileUtils;
import org.dawb.common.util.io.SortingUtils;
import org.dawb.common.util.object.ObjectUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class ImageMonitorView
extends ViewPart
implements MouseListener,
SelectionListener {
    public static final String ID = "org.dawb.workbench.views.imageMonitorView";
    private static Logger logger = LoggerFactory.getLogger(ImageMonitorView.class);
    private Gallery gallery;
    private GalleryItem galleryGroup;
    private BlockingDeque<ImageItem> queue;
    private Thread imageThread;
    private String lastDirectoryPath;
    private String directoryPath;
    private File[] fileList;
    private IReusableEditor editor;
    private Comparator<File> currentComparitor = SortingUtils.DATE_SORT_BACKWARDS;
    private GallerySelectionProvider selectionProvider;
    private boolean monitoringDirectory = false;

    public ImageMonitorView() throws Exception {
        this.queue = new LinkedBlockingDeque<ImageItem>(Integer.MAX_VALUE);
    }

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        this.gallery = new Gallery(composite, 268435972);
        this.gallery.setToolTipText("Double click to open a file, afterwards the same editor will be used where possible. Right click to start a new editor.");
        final DefaultGalleryGroupRenderer defaultGalleryGroupRenderer = new DefaultGalleryGroupRenderer();
        defaultGalleryGroupRenderer.setMinMargin(2);
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.common.ui");
        int n = scopedPreferenceStore.getInt("org.dawb.workbench.views.image.monitor.thumbnail.size");
        scopedPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!propertyChangeEvent.getProperty().equals("org.dawb.workbench.views.image.monitor.thumbnail.size")) {
                    return;
                }
                int n = ObjectUtils.getInteger((Object)propertyChangeEvent.getNewValue());
                defaultGalleryGroupRenderer.setItemHeight(n);
                defaultGalleryGroupRenderer.setItemWidth(n);
                ImageMonitorView.this.refreshAll();
            }
        });
        defaultGalleryGroupRenderer.setItemHeight(n);
        defaultGalleryGroupRenderer.setItemWidth(n);
        defaultGalleryGroupRenderer.setAutoMargin(true);
        this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)defaultGalleryGroupRenderer);
        DefaultGalleryItemRenderer defaultGalleryItemRenderer = new DefaultGalleryItemRenderer();
        this.gallery.setItemRenderer((AbstractGalleryItemRenderer)defaultGalleryItemRenderer);
        this.gallery.setVirtualGroups(true);
        this.gallery.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                GalleryItem galleryItem = (GalleryItem)event.item;
                int n = ImageMonitorView.this.gallery.indexOf(galleryItem);
                galleryItem.setItemCount(n);
                File file = ImageMonitorView.this.getFile(n);
                galleryItem.setText(file.getName());
                ImageItem imageItem = new ImageItem();
                imageItem.setFile(file);
                imageItem.setItem(galleryItem);
                ImageMonitorView.this.queue.offerFirst(imageItem);
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this.gallery, 19);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance(), ResourceTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent dropTargetEvent) {
                if (((DropTarget)dropTargetEvent.getSource()).getControl() == ImageMonitorView.this.gallery) {
                    return;
                }
                Object object = dropTargetEvent.data;
                if (object instanceof String[]) {
                    ImageMonitorView.this.setDirectoryPath(((String[])object)[0]);
                } else if (object instanceof IResource[]) {
                    IResource[] iResourceArray = (IResource[])object;
                    ImageMonitorView.this.setDirectoryPath(iResourceArray[0].getLocation().toOSString());
                } else if (object instanceof File[]) {
                    ImageMonitorView.this.setDirectoryPath(((File[])object)[0].getAbsolutePath());
                }
            }
        });
        DragSource dragSource = new DragSource((Control)this.gallery, 19);
        dragSource.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                if (ImageMonitorView.this.getSelectedPaths() == null) {
                    return;
                }
                dragSourceEvent.data = ImageMonitorView.this.getSelectedPaths();
            }
        });
        this.galleryGroup = new GalleryItem(this.gallery, 0x10000000);
        this.galleryGroup.setText("Please choose a directory to monitor...");
        if (this.directoryPath != null) {
            this.refreshAll();
        }
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
        this.selectionProvider = new GallerySelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.gallery.addMouseListener((MouseListener)this);
        this.gallery.addSelectionListener((SelectionListener)this);
        try {
            this.createImageThread();
        }
        catch (Exception exception) {
            logger.error("Cannot start thumbnail thread!", (Throwable)exception);
        }
    }

    private File getFile(int n) {
        if (this.fileList == null) {
            List list = SortingUtils.getSortedFileList((File)new File(this.directoryPath), (FileFilter)this.getFileFilter(), this.currentComparitor);
            this.fileList = list.toArray(new File[list.size()]);
        }
        return this.fileList[n];
    }

    public void refreshAll() {
        this.refreshAll(false);
    }

    private void refreshAll(final boolean bl) {
        this.queue.clear();
        Job job = new Job("Refresh Image Monitor"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (ImageMonitorView.this.directoryPath == null) {
                    return Status.CANCEL_STATUS;
                }
                List list = SortingUtils.getSortedFileList((File)new File(ImageMonitorView.this.directoryPath), (FileFilter)ImageMonitorView.this.getFileFilter(), (Comparator)ImageMonitorView.this.currentComparitor);
                if (list == null) {
                    ImageMonitorView.this.setItemCount(0, true, false);
                    return Status.CANCEL_STATUS;
                }
                ImageMonitorView.this.fileList = list.toArray(new File[list.size()]);
                ImageMonitorView.this.setItemCount(ImageMonitorView.this.fileList.length, true, bl);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(40);
        job.schedule();
    }

    public void setMonitoring(boolean bl) {
        this.monitoringDirectory = bl;
        this.updateMonitoring();
    }

    public void toggleMonitor() {
        this.monitoringDirectory = !this.monitoringDirectory;
        this.updateMonitoring();
    }

    private void updateMonitoring() {
        if (this.monitoringDirectory) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (ImageMonitorView.this.monitoringDirectory) {
                        Object object;
                        try {
                            object = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.common.ui");
                            int n = object.getInt("org.dawb.workbench.views.image.monitor.poll.rate");
                            long l = n * 1000;
                            Thread.sleep(l);
                        }
                        catch (InterruptedException interruptedException) {
                            logger.error("Cannot monitor " + ImageMonitorView.this.getDirectoryPath(), (Throwable)interruptedException);
                            return;
                        }
                        if (ImageMonitorView.this.fileList == null) continue;
                        object = new File(ImageMonitorView.this.directoryPath);
                        if (!((File)object).exists()) {
                            ImageMonitorView.this.setItemCount(0, true, false);
                            continue;
                        }
                        if (ImageMonitorView.this.lastDirectoryPath != null && ImageMonitorView.this.lastDirectoryPath.equals(ImageMonitorView.this.directoryPath)) {
                            List list = SortingUtils.getSortedFileList((File)new File(ImageMonitorView.this.directoryPath), (FileFilter)ImageMonitorView.this.getFileFilter(), (Comparator)ImageMonitorView.this.currentComparitor);
                            if (list == null) {
                                ImageMonitorView.this.setItemCount(0, true, false);
                                continue;
                            }
                            int n = list.size() - ImageMonitorView.this.fileList.length;
                            if (n != 0) {
                                ImageMonitorView.this.fileList = list.toArray(new File[list.size()]);
                                ImageMonitorView.this.setItemCount(ImageMonitorView.this.fileList.length, false, false);
                            }
                        } else {
                            ImageMonitorView.this.fileList = null;
                            ImageMonitorView.this.refreshAll(true);
                        }
                        ImageMonitorView.this.lastDirectoryPath = ImageMonitorView.this.directoryPath;
                    }
                }
            }, "Image Monitor monitor thread");
            thread.setDaemon(true);
            thread.start();
        }
    }

    private void setItemCount(final int n, final boolean bl, final boolean bl2) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ImageMonitorView.this.queue == null) {
                        return;
                    }
                    ImageMonitorView.this.queue.clear();
                    if (bl) {
                        ImageMonitorView.this.galleryGroup.clearAll();
                    }
                    ImageMonitorView.this.galleryGroup.setItemCount(n);
                    ImageMonitorView.this.galleryGroup.setExpanded(true);
                    ImageMonitorView.this.gallery.update();
                    int n2 = ImageMonitorView.this.galleryGroup.getItemCount();
                    if (n2 > 0) {
                        GalleryItem galleryItem = ImageMonitorView.this.galleryGroup.getItem(n2 - 1);
                        ImageMonitorView.this.gallery.setSelection(new GalleryItem[]{galleryItem});
                        if (bl2) {
                            ImageMonitorView.this.updateSelection();
                        }
                    }
                    ImageMonitorView.this.gallery.getParent().layout(new Control[]{ImageMonitorView.this.gallery});
                }
                catch (Throwable throwable) {
                    logger.error("Error updating gallery content!", throwable);
                }
            }
        });
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite);
        try {
            if (iMemento == null || iMemento.getString("DIR") == null) {
                return;
            }
            this.directoryPath = iMemento.getString("DIR");
        }
        catch (Exception exception) {
            throw new PartInitException(exception.getMessage());
        }
    }

    public void saveState(IMemento iMemento) {
        try {
            iMemento.putString("DIR", this.directoryPath);
        }
        catch (Exception exception) {
            logger.error("Cannot save plot bean", (Throwable)exception);
        }
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String string) {
        this.directoryPath = string;
        this.fileList = null;
        this.refreshAll();
    }

    private void createActions() {
        MenuManager menuManager = new MenuManager();
        this.gallery.setMenu(menuManager.createContextMenu((Control)this.gallery));
        this.getSite().registerContextMenu(menuManager, null);
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        CheckableActionGroup checkableActionGroup = new CheckableActionGroup();
        Action action = new Action("Sort by date, newest at the bottom", 2){

            public void run() {
                ImageMonitorView.this.currentComparitor = SortingUtils.DATE_SORT_BACKWARDS;
                ImageMonitorView.this.refreshAll();
            }
        };
        action.setImageDescriptor(Activator.getImageDescriptor("icons/sortByDate.gif"));
        checkableActionGroup.add((IAction)action);
        iToolBarManager.add((IAction)action);
        action.setChecked(true);
        Action action2 = new Action("Sort by name", 2){

            public void run() {
                ImageMonitorView.this.currentComparitor = SortingUtils.NATURAL_SORT_CASE_INSENSITIVE;
                ImageMonitorView.this.refreshAll();
            }
        };
        action2.setImageDescriptor(Activator.getImageDescriptor("icons/sortByName.gif"));
        checkableActionGroup.add((IAction)action2);
        iToolBarManager.add((IAction)action2);
        iToolBarManager.add((IContributionItem)new Separator());
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
        if (this.gallery != null && !this.gallery.isDisposed()) {
            this.gallery.setFocus();
        }
    }

    protected FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                if (file.isHidden()) {
                    return false;
                }
                String string = file.getName();
                if (string == null || "".equals(string)) {
                    return false;
                }
                if (string.startsWith(".")) {
                    return false;
                }
                if (string.endsWith(".edf")) {
                    return true;
                }
                if (ImageFileUtils.isImage((String)string)) {
                    return true;
                }
                String string2 = FileUtils.getFileExtension((File)file);
                return LoaderFactory.getSupportedExtensions().contains(string2);
            }
        };
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        this.openSelectedLinked();
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.updateSelection();
    }

    private void updateSelection() {
        IEditorDescriptor iEditorDescriptor;
        File file = this.getSelectedFile();
        if (file == null) {
            return;
        }
        IActionBars iActionBars = this.getViewSite().getActionBars();
        iActionBars.getStatusLineManager().setMessage(file.getAbsolutePath());
        if (this.editor != null) {
            try {
                this.editor.getEditorInput();
                this.editor.getEditorSite();
                this.editor.setFocus();
            }
            catch (Throwable throwable) {
                this.editor = null;
            }
        }
        if (this.editor != null) {
            try {
                iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getAbsolutePath());
                if (iEditorDescriptor.getId() != this.editor.getEditorSite().getId()) {
                    IEditorPart iEditorPart = EclipseUtils.openExternalEditor(file.getAbsolutePath());
                    if (iEditorPart instanceof IReusableEditor) {
                        this.editor = (IReusableEditor)iEditorPart;
                    }
                    return;
                }
            }
            catch (PartInitException partInitException) {
                logger.error("Cannot open editor for file: " + file, (Throwable)partInitException);
            }
        }
        if (this.editor != null) {
            iEditorDescriptor = EFS.getLocalFileSystem().fromLocalFile(file);
            FileStoreEditorInput fileStoreEditorInput = new FileStoreEditorInput((IFileStore)iEditorDescriptor);
            this.editor.setInput((IEditorInput)fileStoreEditorInput);
        }
        this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)file));
    }

    public void openSelectedLinked() {
        File file = this.getSelectedFile();
        try {
            IEditorPart iEditorPart = EclipseUtils.openExternalEditor(file.getAbsolutePath());
            if (iEditorPart instanceof IReusableEditor) {
                this.editor = (IReusableEditor)iEditorPart;
            }
        }
        catch (PartInitException partInitException) {
            logger.error("Cannot open editor for file: " + file, (Throwable)partInitException);
        }
    }

    public void openSelected() {
        File file = this.getSelectedFile();
        if (file == null) {
            return;
        }
        try {
            EclipseUtils.openExternalEditor(file.getAbsolutePath());
        }
        catch (PartInitException partInitException) {
            logger.error("Cannot open file " + file, (Throwable)partInitException);
        }
    }

    private File getSelectedFile() {
        GalleryItem[] galleryItemArray = this.gallery.getSelection();
        if (galleryItemArray == null || galleryItemArray.length < 1) {
            return null;
        }
        GalleryItem galleryItem = galleryItemArray[0];
        int n = galleryItem.getItemCount();
        File file = this.getFile(n);
        return file;
    }

    private String[] getSelectedPaths() {
        GalleryItem[] galleryItemArray = this.gallery.getSelection();
        if (galleryItemArray == null || galleryItemArray.length < 1) {
            return null;
        }
        String[] stringArray = new String[galleryItemArray.length];
        int n = 0;
        while (n < galleryItemArray.length) {
            stringArray[n] = this.getFile(galleryItemArray[n].getItemCount()).getAbsolutePath();
            ++n;
        }
        return stringArray;
    }

    public void dispose() {
        this.queue.clear();
        this.queue.add(new ImageItem());
        if (this.gallery != null && !this.gallery.isDisposed()) {
            this.gallery.removeSelectionListener((SelectionListener)this);
            this.gallery.removeMouseListener((MouseListener)this);
            this.gallery.dispose();
        }
        this.gallery = null;
        this.galleryGroup = null;
        this.queue = null;
        this.imageThread = null;
        this.lastDirectoryPath = null;
        this.directoryPath = null;
        this.fileList = null;
        this.editor = null;
    }

    private void createImageThread() throws Exception {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.common.ui");
        IThumbnailService iThumbnailService = (IThumbnailService)ServiceManager.getService(IThumbnailService.class);
        this.imageThread = new Thread(new Runnable((IPreferenceStore)scopedPreferenceStore, iThumbnailService){
            private final /* synthetic */ IPreferenceStore val$store;
            private final /* synthetic */ IThumbnailService val$service;
            {
                this.val$store = iPreferenceStore;
                this.val$service = iThumbnailService;
            }

            @Override
            public void run() {
                while (ImageMonitorView.this.gallery != null && !ImageMonitorView.this.gallery.isDisposed()) {
                    if (ImageMonitorView.this.queue == null) break;
                    ImageItem imageItem = null;
                    try {
                        imageItem = (ImageItem)ImageMonitorView.this.queue.take();
                        if (imageItem == null || imageItem.getItem() == null || imageItem.getFile() == null) {
                            Thread.sleep(100L);
                            continue;
                        }
                        int n = this.val$store.getInt("org.dawb.workbench.views.image.monitor.thumbnail.size");
                        final Image image = this.val$service.createImage(imageItem.getFile(), n);
                        final ImageItem imageItem2 = imageItem;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (imageItem2.getItem().isDisposed()) {
                                    return;
                                }
                                try {
                                    if (image != null) {
                                        imageItem2.getItem().setImage(image);
                                    } else {
                                        imageItem2.getItem().setImage(val$service.getIconForFile(imageItem2.getFile()));
                                    }
                                }
                                catch (Throwable throwable) {
                                    return;
                                }
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        logger.error("Cannot process thumbnail image " + imageItem.getFile());
                        if (!ImageMonitorView.this.gallery.isDisposed()) continue;
                        return;
                    }
                }
                logger.debug("Stopped image thumbail generation thread.");
            }
        }, "Image View Processing Daemon");
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }
}

