/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.views;

import java.io.File;
import java.util.Collection;
import org.dawb.common.services.ILoaderService;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.util.GridUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.IMetadataProvider;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;

public class HeaderTableView
extends ViewPart
implements ISelectionListener,
IPartListener {
    public static final String ID = "fable.imageviewer.views.HeaderView";
    private static final Logger logger = LoggerFactory.getLogger(HeaderTableView.class);
    private IMetaData meta;
    private StructuredSelection lastSelection;
    private boolean requirePageUpdates;
    private TableViewer table;
    UIJob updateTable = new UIJob("Updating Metadata Table"){

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (HeaderTableView.this.table.getControl().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            HeaderTableView.this.table.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object object, Object object2) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object object) {
                    try {
                        return HeaderTableView.this.meta.getMetaNames().toArray(new Object[HeaderTableView.this.meta.getMetaNames().size()]);
                    }
                    catch (Exception exception) {
                        return new Object[]{""};
                    }
                }
            });
            if (HeaderTableView.this.table.getControl().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            HeaderTableView.this.table.setInput((Object)new String());
            return Status.OK_STATUS;
        }
    };

    public HeaderTableView() {
        this(true);
    }

    public HeaderTableView(boolean bl) {
        this.requirePageUpdates = bl;
    }

    public void createPartControl(final Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        GridUtils.removeMargins(composite2);
        final Text text = new Text(composite2, 2944);
        text.setLayoutData((Object)new GridData(768));
        text.setToolTipText("Search on data set name or expression value.");
        this.table = new TableViewer(composite2, 68356);
        this.table.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.getTable().setLinesVisible(true);
        this.table.getTable().setHeaderVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.table, 0, 0);
        tableViewerColumn.getColumn().setText("Key");
        tableViewerColumn.getColumn().setWidth(200);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new HeaderColumnLabelProvider(0));
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.table, 0, 1);
        tableViewerColumn2.getColumn().setText("Value");
        tableViewerColumn2.getColumn().setWidth(200);
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new HeaderColumnLabelProvider(1));
        this.table.setColumnProperties(new String[]{"Key", "Value"});
        this.table.setUseHashlookup(true);
        final HeaderFilter headerFilter = new HeaderFilter();
        this.table.addFilter((ViewerFilter)headerFilter);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (composite.isDisposed()) {
                    return;
                }
                headerFilter.setSearchText(text.getText());
                HeaderTableView.this.table.refresh();
            }
        });
        if (this.requirePageUpdates) {
            IEditorPart iEditorPart;
            IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
            if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null) {
                this.updatePath(EclipseUtils.getFilePath(iEditorPart.getEditorInput()));
            }
            this.getSite().getPage().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
            this.getSite().getPage().addPartListener((IPartListener)this);
        }
    }

    private void updateSelection(ISelection iSelection) {
        if (iSelection == null) {
            return;
        }
        if (iSelection instanceof StructuredSelection) {
            this.lastSelection = (StructuredSelection)iSelection;
            Object object = this.lastSelection.getFirstElement();
            if (object instanceof IFile) {
                String string = ((IFile)object).getLocation().toOSString();
                this.updatePath(string);
            } else if (object instanceof File) {
                String string = ((File)object).getAbsolutePath();
                this.updatePath(string);
            } else if (object instanceof IMetadataProvider) {
                try {
                    this.meta = ((IMetadataProvider)object).getMetadata();
                    this.updatePartName();
                    this.updateTable.schedule();
                }
                catch (Exception exception) {
                    logger.error("Could not capture metadata from selection", (Throwable)exception);
                }
            }
        }
    }

    private void updatePartName() {
        if (this.meta != null) {
            Collection collection = this.meta.getDataNames();
            if (collection != null) {
                this.setPartName("Metadata " + collection.toString());
            } else {
                this.setPartName("Metadata");
            }
        }
    }

    private void getMetaData(final String string) throws InterruptedException {
        Job job = new Job("Extra Meta Data " + string){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                ILoaderService iLoaderService = (ILoaderService)PlatformUI.getWorkbench().getService(ILoaderService.class);
                try {
                    HeaderTableView.this.meta = iLoaderService.getMetaData(string, iProgressMonitor);
                }
                catch (Exception exception) {
                    logger.error("Cannot get meta data for " + string, (Throwable)exception);
                    return Status.CANCEL_STATUS;
                }
                HeaderTableView.this.updateTable.schedule();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void updatePath(String string) {
        try {
            this.getMetaData(string);
            this.setPartName("Header " + new File(string).getName());
        }
        catch (InterruptedException interruptedException) {
            logger.error("Interupted reading meta data.", (Throwable)interruptedException);
        }
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart instanceof IMetadataProvider) {
            try {
                this.meta = ((IMetadataProvider)iWorkbenchPart).getMetadata();
                this.updateTable.schedule();
            }
            catch (Exception exception) {
                logger.error("There was a error reading the metadata from the selection", (Throwable)exception);
            }
        } else {
            this.updateSelection(iSelection);
        }
    }

    public void setFocus() {
        this.table.getControl().setFocus();
    }

    public void dispose() {
        if (this.requirePageUpdates) {
            this.getSite().getPage().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
            this.getSite().getPage().removePartListener((IPartListener)this);
        }
        super.dispose();
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        IEditorPart iEditorPart;
        IEditorInput iEditorInput;
        String string;
        if (iWorkbenchPart instanceof IMetadataProvider) {
            this.updateFromMetaDataProvider(iWorkbenchPart);
        }
        if (iWorkbenchPart instanceof IEditorPart && (string = EclipseUtils.getFilePath(iEditorInput = (iEditorPart = (IEditorPart)iWorkbenchPart).getEditorInput())) != null) {
            this.updatePath(string);
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        this.updateFromMetaDataProvider(iWorkbenchPart);
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    private void updateFromMetaDataProvider(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof IMetadataProvider) {
            try {
                this.meta = ((IMetadataProvider)iWorkbenchPart).getMetadata();
                if (this.meta != null && !this.table.getTable().isDisposed()) {
                    this.updateTable.schedule();
                    this.setPartName("Header " + iWorkbenchPart.getTitle());
                }
            }
            catch (Exception exception) {
                logger.error("Cannot get meta data from " + iWorkbenchPart.getTitle(), (Throwable)exception);
            }
        }
    }

    private class HeaderColumnLabelProvider
    extends ColumnLabelProvider {
        private int column;

        public HeaderColumnLabelProvider(int n) {
            this.column = n;
        }

        public String getText(Object object) {
            if (this.column == 0) {
                return object.toString();
            }
            if (this.column == 1) {
                try {
                    return HeaderTableView.this.meta.getMetaValue(object.toString()).toString();
                }
                catch (Exception exception) {}
            }
            return "";
        }
    }

    class HeaderFilter
    extends ViewerFilter {
        private String searchString;

        HeaderFilter() {
        }

        public void setSearchText(String string) {
            if (string == null) {
                string = "";
            }
            this.searchString = ".*" + string.toLowerCase() + ".*";
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (this.searchString == null || this.searchString.length() == 0) {
                return true;
            }
            String string = (String)object2;
            if (string == null || "".equals(string)) {
                return true;
            }
            if (string.toLowerCase().matches(this.searchString)) {
                return true;
            }
            return string.toLowerCase().matches(this.searchString);
        }
    }
}

