/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.views;

import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.dawb.common.services.IThumbnailService;
import org.dawb.common.services.ServiceManager;
import org.dawb.common.ui.Activator;
import org.dawb.common.ui.menu.CheckableActionGroup;
import org.dawb.common.ui.menu.MenuAction;
import org.dawb.common.ui.slicing.ISlicablePlottingPart;
import org.dawb.common.ui.slicing.ISliceReceiver;
import org.dawb.common.ui.slicing.SliceComponent;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.views.H5GalleryInfo;
import org.dawb.common.ui.views.ImageItem;
import org.dawb.common.util.object.ObjectUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.jface.galleryviewer.GalleryTreeViewer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.SliceObject;

public class H5GalleryView
extends ViewPart
implements MouseListener,
SelectionListener,
ISliceReceiver {
    public static final String ID = "org.dawb.workbench.views.h5GalleryView";
    private static Logger logger = LoggerFactory.getLogger(H5GalleryView.class);
    private Gallery gallery;
    private GalleryItem galleryGroup;
    private BlockingDeque<ImageItem> queue = new LinkedBlockingDeque<ImageItem>(Integer.MAX_VALUE);
    private Thread imageThread;
    private H5GalleryInfo info;
    private MenuAction dimensionList;

    public H5GalleryView() {
        this.createImageThread();
    }

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        this.gallery = new Gallery(composite, 0x10000200);
        this.gallery.setToolTipText("This part is used to navigate an image set inside an hdf5/nexus file.");
        final DefaultGalleryGroupRenderer defaultGalleryGroupRenderer = new DefaultGalleryGroupRenderer();
        defaultGalleryGroupRenderer.setMinMargin(2);
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.common.ui");
        int n = scopedPreferenceStore.getInt("org.dawb.workbench.views.image.monitor.thumbnail.size");
        scopedPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!propertyChangeEvent.getProperty().equals("org.dawb.workbench.views.image.monitor.thumbnail.size")) {
                    return;
                }
                if (defaultGalleryGroupRenderer.getGallery().isDisposed()) {
                    return;
                }
                int n = ObjectUtils.getInteger((Object)propertyChangeEvent.getNewValue());
                defaultGalleryGroupRenderer.setItemHeight(n);
                defaultGalleryGroupRenderer.setItemWidth(n);
                H5GalleryView.this.refreshAll();
            }
        });
        defaultGalleryGroupRenderer.setItemHeight(n);
        defaultGalleryGroupRenderer.setItemWidth(n);
        defaultGalleryGroupRenderer.setAutoMargin(true);
        this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)defaultGalleryGroupRenderer);
        DefaultGalleryItemRenderer defaultGalleryItemRenderer = new DefaultGalleryItemRenderer();
        this.gallery.setItemRenderer((AbstractGalleryItemRenderer)defaultGalleryItemRenderer);
        this.gallery.setVirtualGroups(true);
        this.gallery.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                GalleryItem galleryItem = (GalleryItem)event.item;
                int n = H5GalleryView.this.gallery.indexOf(galleryItem);
                galleryItem.setItemCount(n);
                galleryItem.setText(String.valueOf(n));
                ImageItem imageItem = new ImageItem();
                imageItem.setIndex(n);
                imageItem.setItem(galleryItem);
                H5GalleryView.this.queue.offerFirst(imageItem);
            }
        });
        this.galleryGroup = new GalleryItem(this.gallery, 0x10000000);
        this.galleryGroup.setText("Please choose a directory to monitor...");
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)new GalleryTreeViewer(this.gallery));
        this.gallery.addMouseListener((MouseListener)this);
        this.gallery.addSelectionListener((SelectionListener)this);
    }

    public void createImageGallery(H5GalleryInfo h5GalleryInfo) {
        this.info = h5GalleryInfo;
        this.refreshAll();
    }

    public void refreshAll() {
        this.refreshAll(false);
    }

    private void refreshAll(boolean bl) {
        this.queue.clear();
        Job job = new Job("Refresh Image Monitor"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        H5GalleryView.this.galleryGroup.clearAll();
                        H5GalleryView.this.galleryGroup.setItemCount(H5GalleryView.this.info.getSize());
                        H5GalleryView.this.galleryGroup.setExpanded(true);
                        H5GalleryView.this.galleryGroup.setText(H5GalleryView.this.info.getSlice().getName());
                        H5GalleryView.this.gallery.update();
                        H5GalleryView.this.gallery.getParent().layout(new Control[]{H5GalleryView.this.gallery});
                        GalleryItem galleryItem = H5GalleryView.this.galleryGroup.getItem(H5GalleryView.this.galleryGroup.getItemCount() - 1);
                        H5GalleryView.this.gallery.setSelection(new GalleryItem[]{galleryItem});
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(40);
        job.schedule();
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite);
        try {
            if (iMemento == null || iMemento.getString("DIR") == null) {
                return;
            }
        }
        catch (Exception exception) {
            throw new PartInitException(exception.getMessage());
        }
    }

    public void saveState(IMemento iMemento) {
    }

    private void createActions() {
        MenuManager menuManager = new MenuManager();
        this.gallery.setMenu(menuManager.createContextMenu((Control)this.gallery));
        this.getSite().registerContextMenu(menuManager, null);
    }

    private void initializeToolBar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.dimensionList = new MenuAction("Slice dimension");
        this.dimensionList.setImageDescriptor(Activator.getImageDescriptor("icons/slice_dimension.gif"));
        iToolBarManager.add((IAction)this.dimensionList);
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
        if (this.gallery != null && !this.gallery.isDisposed()) {
            this.gallery.setFocus();
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        System.out.println("Open slice!");
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.updateSelection();
    }

    private void updateSelection() {
        ISlicablePlottingPart iSlicablePlottingPart;
        SliceComponent sliceComponent;
        int n = this.getSelectedIndex();
        if (n < 0) {
            return;
        }
        IEditorPart iEditorPart = EclipseUtils.getActiveEditor();
        if (iEditorPart instanceof ISlicablePlottingPart && (sliceComponent = (iSlicablePlottingPart = (ISlicablePlottingPart)iEditorPart).getSliceComponent()) != null) {
            sliceComponent.setSliceIndex(this.info.getSliceDimension(), n);
        }
    }

    private int getSelectedIndex() {
        GalleryItem[] galleryItemArray = this.gallery.getSelection();
        if (galleryItemArray == null || galleryItemArray.length < 1) {
            return -1;
        }
        GalleryItem galleryItem = galleryItemArray[0];
        int n = galleryItem.getItemCount();
        return n;
    }

    public void dispose() {
        this.queue.clear();
        this.queue.add(new ImageItem());
        if (this.gallery != null && !this.gallery.isDisposed()) {
            this.gallery.removeSelectionListener((SelectionListener)this);
            this.gallery.removeMouseListener((MouseListener)this);
            this.gallery.dispose();
        }
        this.gallery = null;
        this.galleryGroup = null;
        this.queue = null;
        this.imageThread = null;
        this.info = null;
    }

    private void createImageThread() {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.common.ui");
        this.imageThread = new Thread(new Runnable((IPreferenceStore)scopedPreferenceStore){
            private final /* synthetic */ IPreferenceStore val$store;
            {
                this.val$store = iPreferenceStore;
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        AbstractDataset abstractDataset;
                        SliceObject sliceObject;
                        ImageItem imageItem;
                        block10: {
                            if (H5GalleryView.this.queue == null) {
                                return;
                            }
                            imageItem = (ImageItem)H5GalleryView.this.queue.take();
                            if (imageItem.getItem() == null) {
                                return;
                            }
                            if (imageItem.getIndex() < 0) {
                                return;
                            }
                            if (imageItem.getItem().isDisposed()) continue;
                            sliceObject = H5GalleryView.this.info.getSlice();
                            sliceObject.setSliceStart(H5GalleryView.this.getSliceStart(imageItem.getIndex()));
                            sliceObject.setSliceStop(H5GalleryView.this.getSliceStop(imageItem.getIndex()));
                            sliceObject.setSliceStep(H5GalleryView.this.getSliceStep(imageItem.getIndex()));
                            abstractDataset = null;
                            try {
                                abstractDataset = LoaderFactory.getSlice((SliceObject)sliceObject, null);
                                if (abstractDataset == null) {
                                }
                                break block10;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                logger.debug("Encountered invalid shape with " + sliceObject);
                            }
                            continue;
                        }
                        abstractDataset.setShape(sliceObject.getSlicedShape());
                        int n = this.val$store.getInt("org.dawb.workbench.views.image.monitor.thumbnail.size");
                        if (n < 1) {
                            n = 96;
                        }
                        IThumbnailService iThumbnailService = (IThumbnailService)ServiceManager.getService(IThumbnailService.class);
                        final Image image = iThumbnailService.getThumbnailImage(abstractDataset, n);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (imageItem.getItem().isDisposed()) {
                                    return;
                                }
                                if (imageItem.getItem().getParent().isDisposed()) {
                                    return;
                                }
                                if (image.isDisposed()) {
                                    return;
                                }
                                if (image != null) {
                                    imageItem.getItem().setImage(image);
                                }
                            }
                        });
                    }
                }
                catch (Throwable throwable) {
                    logger.error("Cannot process images", throwable);
                    return;
                }
            }
        }, "Image View Processing Daemon");
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }

    protected int[] getSliceStart(int n) {
        int[] nArray = new int[this.info.getShape().length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = n2 == this.info.getSliceDimension() ? n : this.info.getStart(n2);
            ++n2;
        }
        return nArray;
    }

    protected int[] getSliceStop(int n) {
        int[] nArray = new int[this.info.getShape().length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = n2 == this.info.getSliceDimension() ? n + 1 : this.info.getStop(n2);
            ++n2;
        }
        return nArray;
    }

    protected int[] getSliceStep(int n) {
        int[] nArray = new int[this.info.getShape().length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = 1;
            ++n2;
        }
        return nArray;
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    @Override
    public void updateSlice(int[] nArray, SliceObject sliceObject) {
        final H5GalleryInfo h5GalleryInfo = new H5GalleryInfo();
        h5GalleryInfo.setShape(nArray);
        h5GalleryInfo.setSlice(sliceObject);
        h5GalleryInfo.createDefaultSliceDimension();
        this.createImageGallery(h5GalleryInfo);
        this.dimensionList.clear();
        CheckableActionGroup checkableActionGroup = new CheckableActionGroup();
        List<Integer> list = h5GalleryInfo.getSliceableDimensions();
        for (final int n : list) {
            Action action = new Action("" + (n + 1), 2){

                public void run() {
                    h5GalleryInfo.setSliceDimension(n);
                    H5GalleryView.this.refreshAll();
                }
            };
            if (h5GalleryInfo.getSliceDimension() == n) {
                action.setChecked(true);
            }
            action.setToolTipText("Slice using the dimension " + n + " of the data.");
            this.dimensionList.add((IAction)action);
            checkableActionGroup.add((IAction)action);
        }
        this.getViewSite().getActionBars().getToolBarManager().update(true);
    }
}

