/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.io.SliceObject;

public class H5GalleryInfo {
    private SliceObject slice;
    private int[] shape;
    private int sliceDimension;

    public void createDefaultSliceDimension() {
        this.sliceDimension = this.getDefaultSliceDimension();
    }

    public boolean isNonAxisDimension(int n) {
        return !this.slice.isAxis(n);
    }

    private int getDefaultSliceDimension() {
        int n = 0;
        while (n < this.shape.length) {
            if (!this.slice.isAxis(n) && this.shape[n] > 1) {
                return n;
            }
            ++n;
        }
        n = 0;
        while (n < this.shape.length) {
            if (!this.slice.isAxis(n)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public List<Integer> getSliceableDimensions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.shape.length);
        int n = 0;
        while (n < this.shape.length) {
            if (!this.slice.isAxis(n)) {
                arrayList.add(n);
            }
            ++n;
        }
        return arrayList;
    }

    public int getSliceDimension() {
        return this.sliceDimension;
    }

    public void setSliceDimension(int n) {
        this.sliceDimension = n;
    }

    public int getSize() {
        return this.shape[this.getSliceDimension()];
    }

    public SliceObject getSlice() {
        return this.slice;
    }

    public void setSlice(SliceObject sliceObject) {
        this.slice = sliceObject;
    }

    public int[] getShape() {
        return this.shape;
    }

    public void setShape(int[] nArray) {
        this.shape = nArray;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.shape);
        n = 31 * n + (this.slice == null ? 0 : this.slice.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        H5GalleryInfo h5GalleryInfo = (H5GalleryInfo)object;
        if (!Arrays.equals(this.shape, h5GalleryInfo.shape)) {
            return false;
        }
        return !(this.slice == null ? h5GalleryInfo.slice != null : !this.slice.equals((Object)h5GalleryInfo.slice));
    }

    public int getStart(int n) {
        if (this.slice.getSlicedShape().length == 2 || !this.isNonAxisDimension(n)) {
            return 0;
        }
        if (this.slice.getSlicedShape().length == 1) {
            return this.slice.getSliceStart()[n];
        }
        throw new RuntimeException("Can only deal with 1D and 2D slices!");
    }

    public int getStop(int n) {
        if (this.slice.getSlicedShape().length == 2 || !this.isNonAxisDimension(n)) {
            return this.getShape()[n];
        }
        if (this.slice.getSlicedShape().length == 1) {
            return this.slice.getSliceStart()[n] + 1;
        }
        throw new RuntimeException("Can only deal with 1D and 2D slices!");
    }
}

