/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GridUtils {
    private static int depthCount = 0;
    private static Set<Control> controlsToLayout = new HashSet<Control>();
    private static Stack<Control> controlsToRedraw = new Stack();

    public static void startMultiLayout(Control control) {
        if (control != null) {
            control.setRedraw(false);
        }
        controlsToRedraw.push(control);
        ++depthCount;
    }

    public static void endMultiLayout() {
        Control[] controlArray;
        if (--depthCount == 0 && controlsToLayout.size() > 0) {
            controlArray = controlsToLayout.toArray(new Control[controlsToLayout.size()]);
            controlArray[0].getShell().layout(controlArray);
            Control[] controlArray2 = controlArray;
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray2[n2];
                control.setRedraw(true);
                ++n2;
            }
            controlsToLayout.clear();
        }
        if ((controlArray = controlsToRedraw.pop()) != null) {
            controlArray.setRedraw(true);
        }
    }

    public static void setVisibleAndLayout(Control control, boolean bl) {
        if (control == null) {
            return;
        }
        if (!(control.getLayoutData() instanceof GridData)) {
            throw new IllegalArgumentException("Widget must have GridData layout data applied");
        }
        GridData gridData = (GridData)control.getLayoutData();
        if (gridData.exclude != !bl || control.getVisible() != bl) {
            boolean bl2 = gridData.exclude = !bl;
            if (depthCount == 0) {
                control.setVisible(bl);
                try {
                    control.getShell().layout(new Control[]{control});
                }
                catch (Exception exception) {}
            } else {
                if (!controlsToLayout.contains(control)) {
                    control.setRedraw(false);
                }
                control.setVisible(bl);
                controlsToLayout.add(control);
            }
        }
    }

    public static void setVisible(Control control, boolean bl) {
        if (control == null) {
            return;
        }
        if (control.getLayoutData() instanceof GridData) {
            GridData gridData = (GridData)control.getLayoutData();
            gridData.exclude = !bl;
        }
        control.setVisible(bl);
    }

    public static void layout(Composite composite) {
        if (depthCount == 0) {
            composite.layout();
        } else {
            controlsToLayout.add((Control)composite);
            controlsToLayout.addAll(Arrays.asList(composite.getChildren()));
        }
    }

    public static void layoutFull(Composite composite) {
        if (depthCount == 0) {
            try {
                composite.setRedraw(false);
                composite.getShell().layout(new Control[]{composite});
                composite.layout();
            }
            finally {
                composite.setRedraw(true);
            }
        } else {
            controlsToLayout.add((Control)composite);
            controlsToLayout.addAll(Arrays.asList(composite.getChildren()));
        }
    }

    public static void removeMargins(Composite composite) {
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
    }
}

