/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class EclipseUtils {
    private static final Pattern UNIQUE_PATTERN = Pattern.compile("(.+)(\\d+)", 2);

    public static URI getFileURI(IEditorInput iEditorInput) {
        if (iEditorInput instanceof IURIEditorInput) {
            URI uRI = ((IURIEditorInput)iEditorInput).getURI();
            return uRI;
        }
        return null;
    }

    public static File getFile(IEditorInput iEditorInput) {
        URI uRI = EclipseUtils.getFileURI(iEditorInput);
        return uRI == null ? null : new File(uRI);
    }

    public static String getFilePath(IEditorInput iEditorInput) {
        File file = EclipseUtils.getFile(iEditorInput);
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static IFile getIFile(IEditorInput iEditorInput) {
        if (iEditorInput instanceof FileEditorInput) {
            return ((FileEditorInput)iEditorInput).getFile();
        }
        return (IFile)iEditorInput.getAdapter(IFile.class);
    }

    public static String getFileName(IEditorInput iEditorInput) {
        return EclipseUtils.getFile(iEditorInput).getName();
    }

    public static InputStream getInputStream(IEditorInput iEditorInput) throws Exception {
        if (iEditorInput instanceof FileEditorInput) {
            return ((FileEditorInput)iEditorInput).getFile().getContents();
        }
        return new FileInputStream(EclipseUtils.getFile(iEditorInput));
    }

    public static OutputStream getOutputStream(IEditorInput iEditorInput) throws Exception {
        if (iEditorInput instanceof FileEditorInput) {
            return new FileOutputStream(((FileEditorInput)iEditorInput).getFile().getLocation().toOSString());
        }
        return new FileOutputStream(EclipseUtils.getFile(iEditorInput));
    }

    public static URL getAbsoluteUrl(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (uRL.toString().startsWith("bundle")) {
            try {
                return FileLocator.resolve((URL)uRL);
            }
            catch (IOException iOException) {
                return uRL;
            }
        }
        return uRL;
    }

    public static IWorkbenchPage getPage() {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        if (iWorkbenchPage != null) {
            return iWorkbenchPage;
        }
        return EclipseUtils.getDefaultPage();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getActivePage();
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getPage();
        return iWorkbenchPage.getActiveEditor();
    }

    public static IWorkbenchPage getDefaultPage() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        if (iWorkbenchWindowArray == null) {
            return null;
        }
        return iWorkbenchWindowArray[0].getActivePage();
    }

    public static void addBuilderToProject(IProject iProject, String string) throws CoreException {
        if (!iProject.isOpen()) {
            return;
        }
        IProjectDescription iProjectDescription = iProject.getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(string)) {
                return;
            }
            ++n;
        }
        ICommand iCommand = iProjectDescription.newCommand();
        iCommand.setBuilderName(string);
        ArrayList<ICommand> arrayList = new ArrayList<ICommand>(iCommandArray.length + 1);
        arrayList.addAll(Arrays.asList(iCommandArray));
        arrayList.add(iCommand);
        iProjectDescription.setBuildSpec(arrayList.toArray(new ICommand[arrayList.size()]));
        iProject.setDescription(iProjectDescription, null);
    }

    public static boolean isActivePerspective(String string) {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        if (iWorkbenchPage == null) {
            return false;
        }
        try {
            return string.equals(iWorkbenchPage.getPerspective().getId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void delay(long l) {
        if (PlatformUI.isWorkbenchRunning()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            long l2 = System.currentTimeMillis() + l;
            while (System.currentTimeMillis() < l2) {
                try {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
            }
            display.update();
        } else {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static IFile getUniqueFile(IFile iFile, String string) {
        return EclipseUtils.getUniqueFile(iFile, null, string);
    }

    public static IFile getUniqueFile(IFile iFile, String string, String string2) {
        IContainer iContainer;
        IFile iFile2;
        String string3 = iFile.getName();
        Matcher matcher = Pattern.compile("(.+)(\\d+)\\." + string2, 2).matcher(string3);
        int n = 0;
        String string4 = string3.substring(0, string3.lastIndexOf("."));
        if (matcher.matches()) {
            string4 = matcher.group(1);
            n = Integer.parseInt(matcher.group(2));
        }
        if (string != null) {
            string4 = String.valueOf(string4) + string;
        }
        if ((iFile2 = (iContainer = iFile.getParent()) instanceof IFolder ? ((IFolder)iContainer).getFile(String.valueOf(string4) + "." + string2) : (iContainer instanceof IProject ? ((IProject)iContainer).getFile(String.valueOf(string4) + "." + string2) : null)) != null && !iFile2.exists()) {
            return iFile2;
        }
        return EclipseUtils.getUniqueFile(iContainer, string4, ++n, string2);
    }

    private static IFile getUniqueFile(IContainer iContainer, String string, int n, String string2) {
        IFile iFile;
        if (iContainer instanceof IFolder) {
            iFile = ((IFolder)iContainer).getFile(String.valueOf(string) + n + "." + string2);
        } else if (iContainer instanceof IProject) {
            iFile = ((IProject)iContainer).getFile(String.valueOf(string) + n + "." + string2);
        } else {
            throw new RuntimeException("The parent is neither a project nor a folder.");
        }
        if (!iFile.exists()) {
            return iFile;
        }
        return EclipseUtils.getUniqueFile(iContainer, string, ++n, string2);
    }

    public static String getUnique(IResource iResource) {
        String string;
        String string2 = iResource.getName();
        Matcher matcher = UNIQUE_PATTERN.matcher(string2);
        int n = 0;
        String string3 = string = string2.indexOf(".") > -1 ? string2.substring(0, string2.lastIndexOf(".")) : string2;
        if (matcher.matches()) {
            string = matcher.group(1);
            n = Integer.parseInt(matcher.group(2));
        }
        return EclipseUtils.getUnique(iResource.getParent(), string, ++n);
    }

    private static String getUnique(IContainer iContainer, String string, int n) {
        IFolder iFolder;
        IFile iFile;
        if (iContainer instanceof IFolder) {
            iFile = ((IFolder)iContainer).getFile(String.valueOf(string) + n);
            iFolder = ((IFolder)iContainer).getFolder(String.valueOf(string) + n);
        } else if (iContainer instanceof IProject) {
            iFile = ((IProject)iContainer).getFile(String.valueOf(string) + n);
            iFolder = ((IProject)iContainer).getFolder(String.valueOf(string) + n);
        } else {
            throw new RuntimeException("The parent is niether a project nor a folder.");
        }
        if (!iFile.exists() && !iFolder.exists()) {
            return iFile.getName();
        }
        return EclipseUtils.getUnique(iContainer, string, ++n);
    }

    public static Object getAdapter(Object object, Class<?> clazz) {
        Assert.isNotNull(clazz);
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        return ResourceUtil.getAdapter((Object)object, clazz, (boolean)true);
    }

    public static IEditorPart openEditor(IFile iFile) throws PartInitException {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getPage();
        IEditorDescriptor iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFile.getName());
        if (iEditorDescriptor == null) {
            iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(String.valueOf(iFile.getName()) + ".txt");
        }
        return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), iEditorDescriptor.getId());
    }

    public static IEditorPart openExternalEditor(String string) throws PartInitException {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getPage();
        IEditorDescriptor iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(string);
        if (iEditorDescriptor == null) {
            iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(String.valueOf(string) + ".txt");
        }
        IFileStore iFileStore = EFS.getLocalFileSystem().fromLocalFile(new File(string));
        FileStoreEditorInput fileStoreEditorInput = new FileStoreEditorInput(iFileStore);
        String string2 = iEditorDescriptor.getId();
        return iWorkbenchPage.openEditor((IEditorInput)fileStoreEditorInput, string2);
    }

    public static IProject getActiveProject() {
        IEditorInput iEditorInput;
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart != null && (iEditorInput = iEditorPart.getEditorInput()) instanceof FileEditorInput) {
            return ((FileEditorInput)iEditorInput).getFile().getProject();
        }
        iEditorInput = iWorkbenchPage.getWorkbenchWindow().getSelectionService();
        ISelection iSelection = iEditorInput.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IResource) {
            return ((IResource)object).getProject();
        }
        if (!(object instanceof IAdaptable)) {
            return null;
        }
        IAdaptable iAdaptable = (IAdaptable)object;
        Object object2 = iAdaptable.getAdapter(IResource.class);
        return ((IResource)object2).getProject();
    }

    public static void setBold(Control control) {
        FontData[] fontDataArray = control.getFont().getFontData();
        int n = 0;
        while (n < fontDataArray.length) {
            fontDataArray[n].setStyle(1);
            ++n;
        }
        control.setFont(new Font((Device)control.getDisplay(), fontDataArray));
    }

    public static void setBusy(final boolean bl) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Cursor cursor = display.getSystemCursor(1);
                Shell[] shellArray = display.getShells();
                int n = 0;
                while (n < shellArray.length) {
                    if (bl) {
                        shellArray[n].setCursor(cursor);
                    } else {
                        shellArray[n].setCursor(null);
                    }
                    ++n;
                }
            }
        });
    }

    public static boolean isProjectExisting(String string) {
        return EclipseUtils.getExistingProject(string) != null;
    }

    public static IProject getExistingProject(String string) {
        IProject[] iProjectArray;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray2 = iProjectArray = iWorkspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray2[n2];
            try {
                if (iProject.getNature(string) != null) {
                    return iProject;
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return null;
    }

    public static IWizard openWizard(String string, boolean bl) throws Exception {
        IWizardDescriptor iWizardDescriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(string);
        if (iWizardDescriptor == null) {
            iWizardDescriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(string);
        }
        if (iWizardDescriptor == null) {
            iWizardDescriptor = PlatformUI.getWorkbench().getExportWizardRegistry().findWizard(string);
        }
        if (iWizardDescriptor != null) {
            IWorkbenchWizard iWorkbenchWizard = iWizardDescriptor.createWizard();
            if (bl) {
                WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)iWorkbenchWizard);
                wizardDialog.setTitle(iWorkbenchWizard.getWindowTitle());
                wizardDialog.open();
            }
            return iWorkbenchWizard;
        }
        return null;
    }
}

