/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dawb.common.ui.monitor.ProgressMonitorWrapper;
import org.dawb.common.ui.util.EclipseUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.gda.monitor.IMonitor;

public class CSVUtils {
    private static final Logger logger = LoggerFactory.getLogger(CSVUtils.class);

    public static void createCSV(IFile iFile, Map<String, ? extends IDataset> map, String string) {
        IFile iFile2 = EclipseUtils.getUniqueFile(iFile, string, "csv");
        try {
            String string22;
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = bl = map.size() == 1 && map.values().iterator().next().getShape().length == 2;
            if (bl) {
                CSVUtils.get2DDataSetCVS(stringBuilder, (ILazyDataset)map.values().iterator().next());
            } else {
                int n = Integer.MIN_VALUE;
                for (String string22 : map.keySet()) {
                    IDataset iDataset = map.get(string22);
                    if (iDataset.getShape() == null || iDataset.getShape().length != 1) continue;
                    n = Math.max(n, iDataset.getSize());
                }
                CSVUtils.get1DDataSetCVS(stringBuilder, map, n);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuilder.toString().getBytes());
            iFile2.create((InputStream)byteArrayInputStream, true, (IProgressMonitor)new NullProgressMonitor());
            iFile2.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            string22 = "The file '" + iFile.getName() + "' was converted to '" + iFile2.getName() + "' and placed in the same folder and project.";
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"CVS Exported", (String)string22);
        }
        catch (Exception exception) {
            String string3 = "The file '" + iFile.getName() + "' was not converted to '" + iFile2.getName() + "'";
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"File Not Converted", (String)exception.getMessage(), (IStatus)new Status(2, "org.edna.workbench.actions", string3, (Throwable)exception));
        }
    }

    public static void createCSV(final IFile iFile, final Object[] objectArray) {
        final IFile iFile2 = EclipseUtils.getUniqueFile(iFile, "csv");
        IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
        try {
            iProgressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        DataHolder dataHolder = LoaderFactory.getData((String)iFile.getLocation().toOSString(), (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
                        iFile2.create(CSVUtils.getCVSStream(dataHolder, objectArray), true, iProgressMonitor);
                        iFile2.getParent().refreshLocal(2, iProgressMonitor);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    EclipseUtils.openEditor(iFile2);
                                }
                                catch (PartInitException partInitException) {
                                    logger.error("Cannot open editor for " + iFile2, (Throwable)partInitException);
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        throw new InvocationTargetException(exception, exception.getMessage());
                    }
                }
            });
        }
        catch (Exception exception) {
            String string = "The file '" + iFile.getName() + "' was not converted to '" + iFile2.getName() + "'";
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"File Not Converted", (String)exception.getMessage(), (IStatus)new Status(2, "org.edna.workbench.actions", string, (Throwable)exception));
        }
    }

    protected static InputStream getCVSStream(DataHolder dataHolder, Object[] objectArray) throws Exception {
        CharSequence charSequence2;
        List<Object> list = objectArray != null ? Arrays.asList(objectArray) : null;
        TreeMap treeMap = new TreeMap();
        treeMap.putAll(dataHolder.getMap());
        if (list != null) {
            treeMap.keySet().retainAll(list);
        }
        boolean bl = false;
        int n = Integer.MIN_VALUE;
        for (CharSequence charSequence2 : treeMap.keySet()) {
            ILazyDataset iLazyDataset = (ILazyDataset)treeMap.get(charSequence2);
            if (iLazyDataset.getShape() == null || iLazyDataset.getShape().length != 1) continue;
            n = Math.max(n, iLazyDataset.getSize());
            bl = true;
        }
        charSequence2 = new StringBuilder();
        if (bl) {
            CSVUtils.get1DDataSetCVS((StringBuilder)charSequence2, treeMap, n);
        } else if (treeMap.size() == 1) {
            ILazyDataset iLazyDataset = (ILazyDataset)treeMap.values().iterator().next();
            if (iLazyDataset.getShape()[0] * iLazyDataset.getShape()[1] > 64000) {
                throw new Exception("The data contains an image " + iLazyDataset.getShape()[0] + "x" + iLazyDataset.getShape()[1] + " which cannot be converted to csv.");
            }
            CSVUtils.get2DDataSetCVS((StringBuilder)charSequence2, iLazyDataset);
        } else {
            throw new Exception("The data cannot be parsed to csv.");
        }
        return new ByteArrayInputStream(((StringBuilder)charSequence2).toString().getBytes());
    }

    private static void get2DDataSetCVS(StringBuilder stringBuilder, ILazyDataset iLazyDataset) {
        int n = iLazyDataset.getShape()[0];
        int n2 = iLazyDataset.getShape()[1];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                stringBuilder.append(((IDataset)iLazyDataset).getDouble(new int[]{n4, n3}));
                if (n4 < n - 1) {
                    stringBuilder.append(",");
                }
                ++n4;
            }
            stringBuilder.append("\r\n");
            ++n3;
        }
    }

    private static void get1DDataSetCVS(StringBuilder stringBuilder, Map<String, ? extends ILazyDataset> map, int n) {
        Object object;
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuilder.append("\"");
            stringBuilder.append((String)object);
            stringBuilder.append("\"");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("\r\n");
        int n2 = 0;
        while (n2 < n) {
            object = map.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                ILazyDataset iLazyDataset = map.get(string);
                String string2 = n2 < iLazyDataset.getSize() ? String.valueOf(((IDataset)iLazyDataset).getDouble(new int[]{n2})) : " ";
                stringBuilder.append(string2);
                if (!object.hasNext()) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("\r\n");
            ++n2;
        }
    }
}

