/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.slicing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dawb.common.ui.monitor.ProgressMonitorWrapper;
import org.dawb.common.ui.plot.IPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.slicing.DimsData;
import org.dawb.common.ui.slicing.DimsDataList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.SliceObject;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.monitor.IMonitor;

public class SliceUtils {
    private static Logger logger = LoggerFactory.getLogger(SliceUtils.class);

    public static SliceObject createSliceObject(DimsDataList dimsDataList, int[] nArray, SliceObject sliceObject) {
        SliceObject sliceObject2 = sliceObject != null ? sliceObject.clone() : new SliceObject();
        int[] nArray2 = new int[dimsDataList.size()];
        int[] nArray3 = new int[dimsDataList.size()];
        int[] nArray4 = new int[dimsDataList.size()];
        AbstractDataset abstractDataset = null;
        AbstractDataset abstractDataset2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < dimsDataList.size()) {
            DimsData dimsData = dimsDataList.getDimsData(n);
            nArray2[n] = SliceUtils.getStart(dimsData);
            nArray3[n] = SliceUtils.getStop(dimsData, nArray[n]);
            nArray4[n] = SliceUtils.getStep(dimsData);
            if (dimsData.getAxis() < 0) {
                stringBuilder.append(" (Dim " + (dimsData.getDimension() + 1) + " = " + (dimsData.getSliceRange() != null ? dimsData.getSliceRange() : Integer.valueOf(dimsData.getSlice())) + ")");
            }
            if (dimsData.getAxis() == 0) {
                abstractDataset = SliceUtils.createAxisDataset(nArray[n]);
                abstractDataset.setName("Dimension " + (dimsData.getDimension() + 1));
                sliceObject2.setX(dimsData.getDimension());
            }
            if (dimsData.getAxis() == 1) {
                abstractDataset2 = SliceUtils.createAxisDataset(nArray[n]);
                abstractDataset2.setName("Dimension " + (dimsData.getDimension() + 1));
                sliceObject2.setY(dimsData.getDimension());
            }
            if (dimsData.getSliceRange() != null && dimsData.getAxis() < 0) {
                sliceObject2.setRange(true);
            }
            ++n;
        }
        if (abstractDataset == null || abstractDataset.getSize() < 2) {
            logger.debug("Cannot slice into an image because one of the dimensions is size of 1");
            return null;
        }
        if (abstractDataset2 != null) {
            sliceObject2.setSlicedShape(new int[]{abstractDataset.getSize(), abstractDataset2.getSize()});
            sliceObject2.setAxes(Arrays.asList(abstractDataset, abstractDataset2));
        } else {
            sliceObject2.setSlicedShape(new int[]{abstractDataset.getSize()});
            sliceObject2.setAxes(Arrays.asList(abstractDataset));
        }
        sliceObject2.setSliceStart(nArray2);
        sliceObject2.setSliceStop(nArray3);
        sliceObject2.setSliceStep(nArray4);
        sliceObject2.setShapeMessage(stringBuilder.toString());
        return sliceObject2;
    }

    private static int getStart(DimsData dimsData) {
        if (dimsData.getAxis() > -1) {
            return 0;
        }
        if (dimsData.getSliceRange() != null) {
            double[] dArray = DOEUtils.getRange((String)dimsData.getSliceRange(), null);
            return (int)dArray[0];
        }
        return dimsData.getSlice();
    }

    private static int getStop(DimsData dimsData, int n) {
        if (dimsData.getAxis() > -1) {
            return n;
        }
        if (dimsData.getSliceRange() != null) {
            double[] dArray = DOEUtils.getRange((String)dimsData.getSliceRange(), null);
            return (int)dArray[1];
        }
        return dimsData.getSlice() + 1;
    }

    private static int getStep(DimsData dimsData) {
        if (dimsData.getAxis() > -1) {
            return 1;
        }
        if (dimsData.getSliceRange() != null) {
            double[] dArray = DOEUtils.getRange((String)dimsData.getSliceRange(), null);
            return (int)dArray[2];
        }
        return 1;
    }

    public static AbstractDataset createAxisDataset(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = n2;
            ++n2;
        }
        IntegerDataset integerDataset = new IntegerDataset(nArray, new int[]{n});
        return integerDataset;
    }

    public static void plotSlice(SliceObject sliceObject, int[] nArray, PlotType plotType, IPlottingSystem iPlottingSystem, IProgressMonitor iProgressMonitor) throws Exception {
        if (iProgressMonitor != null) {
            iProgressMonitor.worked(1);
        }
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return;
        }
        sliceObject.setFullShape(nArray);
        AbstractDataset abstractDataset = SliceUtils.getSlice(sliceObject, iProgressMonitor);
        if (abstractDataset == null) {
            return;
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.worked(1);
        }
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return;
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.worked(1);
        }
        if (plotType == PlotType.PT1D) {
            iPlottingSystem.clear();
            iPlottingSystem.createPlot1D(abstractDataset, null, iProgressMonitor);
        } else if (plotType == PlotType.PT1D_MULTI || plotType == PlotType.PT1D_STACKED) {
            int[] nArray2 = abstractDataset.getShape();
            ArrayList<double[]> arrayList = new ArrayList<double[]>(nArray2[1]);
            int n = 0;
            while (n < nArray2[0]) {
                int n2 = 0;
                while (n2 < nArray2[1]) {
                    if (n2 > arrayList.size() - 1) {
                        arrayList.add(new double[nArray2[0]]);
                    }
                    Object object = (double[])arrayList.get(n2);
                    object[n] = abstractDataset.getDouble(new int[]{n, n2++});
                }
                ++n;
            }
            ArrayList<AbstractDataset> arrayList2 = new ArrayList<AbstractDataset>(nArray2[1]);
            for (double[] dArray : arrayList) {
                arrayList2.add((AbstractDataset)new DoubleDataset(dArray, new int[]{dArray.length}));
            }
            iPlottingSystem.createPlot1D((AbstractDataset)arrayList2.get(0), arrayList2, iProgressMonitor);
        } else {
            iPlottingSystem.createPlot2D(abstractDataset, sliceObject.getAxes(), iProgressMonitor);
        }
    }

    public static AbstractDataset getSlice(SliceObject sliceObject, IProgressMonitor iProgressMonitor) throws Exception {
        int[] nArray = sliceObject.getFullShape();
        AbstractDataset abstractDataset = LoaderFactory.getSlice((SliceObject)sliceObject, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
        abstractDataset.setName("Slice of " + sliceObject.getName() + " (full shape " + Arrays.toString(nArray) + ")" + sliceObject.getShapeMessage());
        if (sliceObject.isRange()) {
            AbstractDataset abstractDataset2 = abstractDataset;
            int n = nArray.length;
            int n2 = n - 1;
            while (n2 >= 0) {
                if (!sliceObject.isAxis(n2) && nArray[n2] > 1) {
                    abstractDataset2 = abstractDataset2.sum(n2);
                }
                if (iProgressMonitor != null) {
                    iProgressMonitor.worked(1);
                }
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                    return null;
                }
                --n2;
            }
            if (sliceObject.getX() > sliceObject.getY()) {
                abstractDataset2 = abstractDataset2.transpose(new int[0]);
            }
            if (iProgressMonitor != null) {
                iProgressMonitor.worked(1);
            }
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                return null;
            }
            abstractDataset2.setName(abstractDataset.getName());
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                return null;
            }
            abstractDataset = abstractDataset2 = abstractDataset2.squeeze();
        } else {
            abstractDataset.setShape(sliceObject.getSlicedShape());
        }
        return abstractDataset;
    }

    public static List<SliceObject> getExpandedSlices(int[] nArray, Object object) {
        DimsDataList dimsDataList = (DimsDataList)object;
        ArrayList<SliceObject> arrayList = new ArrayList<SliceObject>(89);
        SliceUtils.createExpandedSlices(nArray, dimsDataList, 0, new ArrayList<DimsData>(dimsDataList.size()), arrayList);
        return arrayList;
    }

    private static void createExpandedSlices(int[] nArray, DimsDataList dimsDataList, int n, List<DimsData> list, List<SliceObject> list2) {
        DimsData dimsData = dimsDataList.getDimsData(n);
        List<DimsData> list3 = dimsData.expand(nArray[n]);
        for (DimsData dimsData2 : list3) {
            list.add(dimsData2);
            if (n == dimsDataList.size() - 1) {
                SliceObject sliceObject = new SliceObject();
                sliceObject.setFullShape(nArray);
                sliceObject = SliceUtils.createSliceObject(new DimsDataList(list), nArray, sliceObject);
                list2.add(sliceObject);
                list.clear();
                continue;
            }
            SliceUtils.createExpandedSlices(nArray, dimsDataList, n + 1, list, list2);
        }
    }
}

