/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.slicing;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.dawb.common.ui.Activator;
import org.dawb.common.ui.DawbUtils;
import org.dawb.common.ui.plot.IPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.slicing.DimsData;
import org.dawb.common.ui.slicing.DimsDataList;
import org.dawb.common.ui.slicing.ISliceReceiver;
import org.dawb.common.ui.slicing.SliceUtils;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.util.GridUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.io.SliceObject;
import uk.ac.gda.richbeans.components.cell.CComboCellEditor;
import uk.ac.gda.richbeans.components.cell.SpinnerCellEditorWithPlayButton;
import uk.ac.gda.richbeans.components.scalebox.RangeBox;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public class SliceComponent {
    private static final Logger logger = LoggerFactory.getLogger(SliceComponent.class);
    private static final List<String> COLUMN_PROPERTIES = Arrays.asList("Dimension", "Axis", "Slice");
    private SliceObject sliceObject;
    private SliceObject currentSlice;
    private int[] dataShape;
    private IPlottingSystem plottingSystem;
    private boolean autoUpdate = true;
    private TableViewer viewer;
    private DimsDataList dimsDataList;
    private CLabel errorLabel;
    private CLabel explain;
    private Button updateAutomatically;
    private Button rangeMode;
    private Composite area;
    protected final BlockingDeque<SliceObject> sliceQueue;
    private Thread sliceServiceThread;
    private String sliceReceiverId;
    private PlotType imagePlotType = PlotType.IMAGE;

    public SliceComponent(String string) {
        this.sliceQueue = new LinkedBlockingDeque<SliceObject>(7);
        this.sliceReceiverId = string;
    }

    public Control createPartControl(Composite composite) {
        this.area = new Composite(composite, 0);
        this.area.setLayout((Layout)new GridLayout(1, false));
        this.explain = new CLabel(this.area, 64);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = 44;
        this.explain.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(this.area, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new TableViewer(this.area, 68356);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.createColumns(this.viewer);
        this.viewer.setUseHashlookup(true);
        this.viewer.setColumnProperties(COLUMN_PROPERTIES.toArray(new String[COLUMN_PROPERTIES.size()]));
        this.viewer.setCellEditors(this.createCellEditors(this.viewer));
        this.viewer.setCellModifier(this.createModifier(this.viewer));
        this.errorLabel = new CLabel(this.area, 0);
        this.errorLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.errorLabel.setImage(Activator.getImageDescriptor("icons/error.png").createImage());
        GridUtils.setVisible((Control)this.errorLabel, false);
        Composite composite3 = new Composite(this.area, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayoutData((Object)new GridData(4, 4, true, true));
        composite4.setLayout((Layout)new GridLayout(1, false));
        this.updateAutomatically = new Button(composite4, 32);
        this.updateAutomatically.setText("Automatic update");
        this.updateAutomatically.setToolTipText("Update plot when slice changes");
        this.updateAutomatically.setSelection(true);
        this.updateAutomatically.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.updateAutomatically.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SliceComponent.this.autoUpdate = SliceComponent.this.updateAutomatically.getSelection();
                SliceComponent.this.slice(false);
            }
        });
        this.rangeMode = new Button(composite4, 32);
        this.rangeMode.setText("Slice as range");
        this.rangeMode.setToolTipText("Enter the slice as a range, which is summed.");
        this.rangeMode.setSelection(false);
        this.rangeMode.setLayoutData((Object)new GridData(16384, 128, true, true));
        this.rangeMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SliceComponent.this.updateRangeModeType();
            }
        });
        Composite composite5 = new Composite(composite3, 0);
        composite5.setLayoutData((Object)new GridData(131072, 4, true, false));
        composite5.setLayout((Layout)new GridLayout(1, false));
        Button button = new Button(composite5, 0);
        button.setToolTipText("Open data set in a gallery.");
        button.setImage(Activator.getImageDescriptor("icons/imageStack.png").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SliceComponent.this.openGallery();
            }
        });
        MenuManager menuManager = new MenuManager();
        Action action = new Action("Open data in gallery", Activator.getImageDescriptor("icons/imageStack.png")){

            public void run() {
                SliceComponent.this.openGallery();
            }
        };
        menuManager.add((IAction)action);
        Menu menu = menuManager.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
                SliceComponent.this.interrupt();
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                if (SliceComponent.this.dimsDataList == null) {
                    return DimsDataList.getDefault();
                }
                return SliceComponent.this.dimsDataList.getElements();
            }
        });
        this.viewer.setInput(new Object());
        return this.area;
    }

    protected void openGallery() {
        IViewPart iViewPart;
        if (this.sliceReceiverId == null) {
            return;
        }
        SliceObject sliceObject = SliceUtils.createSliceObject(this.dimsDataList, this.dataShape, this.sliceObject);
        try {
            iViewPart = EclipseUtils.getActivePage().showView(this.sliceReceiverId);
        }
        catch (PartInitException partInitException) {
            logger.error("Cannot find view " + this.sliceReceiverId);
            return;
        }
        if (iViewPart instanceof ISliceReceiver) {
            ((ISliceReceiver)iViewPart).updateSlice(this.dataShape, sliceObject);
        }
    }

    protected void updateRangeModeType() {
        SpinnerCellEditorWithPlayButton spinnerCellEditorWithPlayButton = (SpinnerCellEditorWithPlayButton)this.viewer.getCellEditors()[2];
        spinnerCellEditorWithPlayButton.setRangeMode(this.rangeMode.getSelection());
        spinnerCellEditorWithPlayButton.setPlayButtonVisible(this.plottingSystem != null);
    }

    private void createDimsData() {
        block15: {
            int n = this.dataShape.length;
            if (this.plottingSystem != null) {
                File file = new File(this.sliceObject.getPath());
                File file2 = new File(String.valueOf(DawbUtils.getDawbHome()) + file.getName() + "." + this.sliceObject.getName() + ".xml");
                if (file2.exists()) {
                    XMLDecoder xMLDecoder = null;
                    try {
                        try {
                            this.dimsDataList = new DimsDataList();
                            xMLDecoder = new XMLDecoder(new FileInputStream(file2));
                            int n2 = 0;
                            while (n2 < n) {
                                this.dimsDataList.add((DimsData)xMLDecoder.readObject());
                                if (this.dimsDataList.getDimsData(n2).getSliceRange() != null) {
                                    this.rangeMode.setSelection(true);
                                    this.updateRangeModeType();
                                }
                                ++n2;
                            }
                        }
                        catch (Exception exception) {
                            logger.debug("Cannot load slice data from last settings!", (Throwable)exception);
                            this.dimsDataList = null;
                            if (xMLDecoder != null) {
                                xMLDecoder.close();
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (xMLDecoder != null) {
                            xMLDecoder.close();
                        }
                        throw throwable;
                    }
                    if (xMLDecoder != null) {
                        xMLDecoder.close();
                    }
                }
            }
        }
        if (this.dimsDataList == null) {
            try {
                this.dimsDataList = new DimsDataList(this.dataShape, this.sliceObject);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected boolean synchronizeSliceData(DimsData dimsData) {
        int n = dimsData != null ? dimsData.getAxis() : -2;
        int n2 = 0;
        while (n2 < this.dimsDataList.size()) {
            if (!this.dimsDataList.getDimsData(n2).equals(dimsData) && this.dimsDataList.getDimsData(n2).getAxis() == n) {
                this.dimsDataList.getDimsData(n2).setAxis(-1);
            }
            n2 += 1;
        }
        n2 = 0;
        int n3 = 0;
        while (n3 < this.dimsDataList.size()) {
            if (this.dimsDataList.getDimsData(n3).getAxis() == 0) {
                n2 = 1;
            }
            ++n3;
        }
        if (!n2) {
            this.errorLabel.setText("Please set a X axis.");
        }
        GridUtils.setVisible((Control)this.errorLabel, n2 == 0);
        GridUtils.setVisible((Control)this.updateAutomatically, n2 != 0 && this.plottingSystem != null);
        this.errorLabel.getParent().layout(new Control[]{this.errorLabel, this.updateAutomatically});
        return n2 != 0;
    }

    private ICellModifier createModifier(final TableViewer tableViewer) {
        return new ICellModifier(){

            public boolean canModify(Object object, String string) {
                DimsData dimsData = (DimsData)object;
                int n = COLUMN_PROPERTIES.indexOf(string);
                if (n == 0) {
                    return false;
                }
                if (n == 1) {
                    return true;
                }
                if (n == 2) {
                    if (SliceComponent.this.dataShape[dimsData.getDimension()] < 2) {
                        return false;
                    }
                    return dimsData.getAxis() < 0;
                }
                return false;
            }

            public void modify(Object object, String string, Object object2) {
                DimsData dimsData = (DimsData)((IStructuredSelection)tableViewer.getSelection()).getFirstElement();
                int n = COLUMN_PROPERTIES.indexOf(string);
                if (n == 0) {
                    return;
                }
                if (n == 1) {
                    dimsData.setAxis((Integer)object2);
                }
                if (n == 2) {
                    if (object2 instanceof Integer) {
                        dimsData.setSlice((Integer)object2);
                    } else {
                        dimsData.setSliceRange((String)object2);
                    }
                }
                boolean bl = SliceComponent.this.synchronizeSliceData(dimsData);
                tableViewer.cancelEditing();
                tableViewer.refresh();
                if (bl) {
                    SliceComponent.this.slice(false);
                }
            }

            public Object getValue(Object object, String string) {
                DimsData dimsData = (DimsData)object;
                int n = COLUMN_PROPERTIES.indexOf(string);
                if (n == 0) {
                    return dimsData.getDimension();
                }
                if (n == 1) {
                    return dimsData.getAxis();
                }
                if (n == 2) {
                    SpinnerCellEditorWithPlayButton spinnerCellEditorWithPlayButton = (SpinnerCellEditorWithPlayButton)tableViewer.getCellEditors()[2];
                    spinnerCellEditorWithPlayButton.setMaximum(SliceComponent.this.dataShape[dimsData.getDimension()] - 1);
                    return dimsData.getSliceRange() != null ? dimsData.getSliceRange() : Integer.valueOf(dimsData.getSlice());
                }
                return null;
            }
        };
    }

    private CellEditor[] createCellEditors(final TableViewer tableViewer) {
        final CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[0] = null;
        cellEditorArray[1] = new CComboCellEditor((Composite)tableViewer.getTable(), new String[]{"X", "Y", "(Slice)"});
        final CCombo cCombo = ((CComboCellEditor)cellEditorArray[1]).getCombo();
        cCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                CComboCellEditor cComboCellEditor = (CComboCellEditor)cellEditorArray[1];
                if (!cComboCellEditor.isActivated()) {
                    return;
                }
                String string = cCombo.getText();
                if ("".equals(string) || "(Slice)".equals(string)) {
                    cComboCellEditor.applyEditorValueAndDeactivate(-1);
                    return;
                }
                String[] stringArray = cComboCellEditor.getItems();
                if (stringArray != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].equalsIgnoreCase(string)) {
                            cComboCellEditor.applyEditorValueAndDeactivate(n);
                            return;
                        }
                        ++n;
                    }
                }
            }
        });
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.workbench.ui");
        cellEditorArray[2] = new SpinnerCellEditorWithPlayButton(tableViewer, "Play through slices", (long)scopedPreferenceStore.getInt("data.format.slice.play.speed"));
        ((SpinnerCellEditorWithPlayButton)cellEditorArray[2]).addValueListener((ValueListener)new ValueAdapter(){

            public void valueChangePerformed(ValueEvent valueEvent) {
                DimsData dimsData = (DimsData)((IStructuredSelection)tableViewer.getSelection()).getFirstElement();
                if (valueEvent.getValue() instanceof Number) {
                    dimsData.setSlice(((Number)valueEvent.getValue()).intValue());
                    dimsData.setSliceRange(null);
                } else {
                    if (((RangeBox)valueEvent.getSource()).isError()) {
                        return;
                    }
                    dimsData.setSliceRange((String)valueEvent.getValue());
                }
                if (SliceComponent.this.synchronizeSliceData(dimsData)) {
                    SliceComponent.this.slice(false);
                }
            }
        });
        return cellEditorArray;
    }

    private void createColumns(TableViewer tableViewer) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0x1000000, 0);
        tableViewerColumn.getColumn().setText("Dim");
        tableViewerColumn.getColumn().setWidth(48);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new SliceColumnLabelProvider(0));
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(tableViewer, 0x1000000, 1);
        tableViewerColumn2.getColumn().setText("Axis");
        tableViewerColumn2.getColumn().setWidth(64);
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new SliceColumnLabelProvider(1));
        TableViewerColumn tableViewerColumn3 = new TableViewerColumn(tableViewer, 131072, 2);
        tableViewerColumn3.getColumn().setText("Slice");
        tableViewerColumn3.getColumn().setWidth(100);
        tableViewerColumn3.setLabelProvider((CellLabelProvider)new SliceColumnLabelProvider(2));
    }

    public void setData(String string, String string2, int[] nArray, IPlottingSystem iPlottingSystem) {
        this.interrupt();
        this.saveSettings();
        SliceObject sliceObject = new SliceObject();
        sliceObject.setPath(string2);
        sliceObject.setName(string);
        this.setSliceObject(sliceObject);
        this.setDataShape(nArray);
        this.setPlottingSystem(iPlottingSystem);
        this.explain.setText("Create a slice of " + this.sliceObject.getName() + ".\nIt has the shape " + Arrays.toString(nArray));
        ((SpinnerCellEditorWithPlayButton)this.viewer.getCellEditors()[2]).setRangeDialogTitle("Range for slice in '" + this.sliceObject.getName() + "'");
        if (iPlottingSystem == null) {
            ((SpinnerCellEditorWithPlayButton)this.viewer.getCellEditors()[2]).setPlayButtonVisible(false);
        }
        this.createDimsData();
        this.createSliceQueue();
        this.viewer.refresh();
        this.synchronizeSliceData(null);
        this.slice(true);
        if (this.plottingSystem == null) {
            GridUtils.setVisible((Control)this.updateAutomatically, false);
            this.viewer.getTable().getColumns()[2].setText("Start Index or Slice Range");
        }
    }

    public void slice(boolean bl) {
        if (!bl && !this.autoUpdate) {
            return;
        }
        try {
            SliceObject sliceObject = SliceUtils.createSliceObject(this.dimsDataList, this.dataShape, this.sliceObject);
            if (this.currentSlice != null && this.currentSlice.equals((Object)sliceObject)) {
                return;
            }
            this.sliceQueue.clear();
            if (sliceObject != null) {
                this.sliceQueue.add(sliceObject);
            }
        }
        catch (Exception exception) {
            logger.error("Cannot generate slices", (Throwable)exception);
        }
    }

    public void dispose() {
        this.interrupt();
        this.saveSettings();
    }

    private void saveSettings() {
        if (this.sliceObject == null) {
            return;
        }
        File file = new File(this.sliceObject.getPath());
        File file2 = new File(String.valueOf(DawbUtils.getDawbHome()) + file.getName() + "." + this.sliceObject.getName() + ".xml");
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        XMLEncoder xMLEncoder = null;
        try {
            try {
                xMLEncoder = new XMLEncoder(new FileOutputStream(file2));
                int n = 0;
                while (n < this.dimsDataList.size()) {
                    xMLEncoder.writeObject(this.dimsDataList.getDimsData(n));
                    ++n;
                }
            }
            catch (Exception exception) {
                logger.error("Cannot load slice data from last settings!", (Throwable)exception);
                if (xMLEncoder != null) {
                    xMLEncoder.close();
                }
            }
        }
        finally {
            if (xMLEncoder != null) {
                xMLEncoder.close();
            }
        }
    }

    private void interrupt() {
        if (this.sliceQueue != null) {
            this.sliceQueue.clear();
        }
        if (this.sliceServiceThread != null) {
            if (this.sliceQueue != null) {
                this.sliceQueue.add(new SliceObject());
            }
            try {
                if (this.sliceServiceThread != null) {
                    this.sliceServiceThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                logger.error("Cannot join", (Throwable)interruptedException);
            }
        }
        this.sliceServiceThread = null;
    }

    private void createSliceQueue() {
        if (this.plottingSystem == null) {
            return;
        }
        if (this.sliceServiceThread != null) {
            return;
        }
        this.sliceServiceThread = new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 11[SIMPLE_IF_TAKEN]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, "Slice Service");
        this.sliceServiceThread.setPriority(4);
        this.sliceServiceThread.setDaemon(true);
        this.sliceServiceThread.start();
    }

    protected Job createSliceJob(final SliceObject sliceObject) throws InterruptedException {
        if (this.plottingSystem == null) {
            return null;
        }
        Job job = new Job("Slice of " + sliceObject.getName()){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Slice " + sliceObject.getName(), 10);
                try {
                    iProgressMonitor.worked(1);
                    if (iProgressMonitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        PlotType plotType = PlotType.PT1D;
                        if (sliceObject.getAxes().size() == 1) {
                            plotType = PlotType.PT1D;
                        } else if (sliceObject.getAxes().size() == 2) {
                            plotType = SliceComponent.this.imagePlotType;
                        } else {
                            throw new Exception("Only 1D and images supported currently!");
                        }
                        SliceUtils.plotSlice(sliceObject, SliceComponent.this.dataShape, plotType, SliceComponent.this.plottingSystem, iProgressMonitor);
                    }
                    catch (Exception exception) {
                        logger.error("Cannot slice " + sliceObject.getName(), (Throwable)exception);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setUser(false);
        return job;
    }

    public void setSliceObject(SliceObject sliceObject) {
        this.sliceObject = sliceObject;
    }

    public void setDataShape(int[] nArray) {
        this.dataShape = nArray;
    }

    public void setPlottingSystem(IPlottingSystem iPlottingSystem) {
        this.plottingSystem = iPlottingSystem;
    }

    public void setVisible(boolean bl) {
        this.area.setVisible(bl);
        this.area.getParent().layout(new Control[]{this.area});
        if (!bl) {
            this.interrupt();
            this.saveSettings();
        }
    }

    public void setSliceIndex(int n, int n2) {
        this.viewer.cancelEditing();
        this.dimsDataList.getDimsData(n).setSlice(n2);
        this.viewer.refresh();
        this.slice(true);
    }

    public DimsDataList getDimsDataList() {
        return this.dimsDataList;
    }

    public void setDimsDataList(DimsDataList dimsDataList) {
        this.dimsDataList = dimsDataList;
        this.rangeMode.setSelection(dimsDataList.isRangeDefined());
        this.viewer.refresh();
    }

    public void setImagePlotType(PlotType plotType) {
        this.imagePlotType = plotType;
    }

    static /* synthetic */ TableViewer access$7(SliceComponent sliceComponent) {
        return sliceComponent.viewer;
    }

    static /* synthetic */ void access$8(SliceComponent sliceComponent, SliceObject sliceObject) {
        sliceComponent.currentSlice = sliceObject;
    }

    private class SliceColumnLabelProvider
    extends ColumnLabelProvider {
        private int col;

        public SliceColumnLabelProvider(int n) {
            this.col = n;
        }

        public String getText(Object object) {
            DimsData dimsData = (DimsData)object;
            switch (this.col) {
                case 0: {
                    return String.valueOf(dimsData.getDimension() + 1);
                }
                case 1: {
                    int n = dimsData.getAxis();
                    return n == 0 ? "X" : (n == 1 ? "Y" : "(Slice)");
                }
                case 2: {
                    if (dimsData.getSliceRange() != null) {
                        return dimsData.getSliceRange();
                    }
                    int n = dimsData.getSlice();
                    return n > -1 ? String.valueOf(n) : "";
                }
            }
            return "";
        }
    }
}

