/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.slicing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dawb.common.ui.slicing.DimsData;
import uk.ac.diamond.scisoft.analysis.io.SliceObject;

public class DimsDataList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<DimsData> dimsData;

    public DimsDataList() {
    }

    public DimsDataList(List<DimsData> list) {
        this.dimsData = list;
    }

    public DimsDataList(int[] nArray, SliceObject sliceObject) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < nArray.length) {
            this.add(new DimsData(n));
            ++n;
        }
        n = nArray.length - 1;
        while (n >= 0) {
            if (nArray[n] > 1) {
                if (!bl2) {
                    this.getDimsData(n).setAxis(1);
                    bl2 = true;
                } else if (!bl) {
                    this.getDimsData(n).setAxis(0);
                    bl = true;
                }
            }
            --n;
        }
    }

    public List<DimsData> getDimsData() {
        return this.dimsData;
    }

    public void setDimsData(List<DimsData> list) {
        this.dimsData = list;
    }

    public void add(DimsData dimsData) {
        if (this.dimsData == null) {
            this.dimsData = new ArrayList<DimsData>(3);
        }
        if (this.dimsData.size() > dimsData.getDimension() && dimsData.getDimension() > -1) {
            this.dimsData.set(dimsData.getDimension(), dimsData);
        } else {
            this.dimsData.add(dimsData);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.dimsData == null ? 0 : this.dimsData.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DimsDataList dimsDataList = (DimsDataList)object;
        return !(this.dimsData == null ? dimsDataList.dimsData != null : !this.dimsData.equals(dimsDataList.dimsData));
    }

    public static Object[] getDefault() {
        return new DimsData[]{new DimsData(0)};
    }

    public Object[] getElements() {
        if (this.dimsData == null) {
            return null;
        }
        return this.dimsData.toArray(new DimsData[this.dimsData.size()]);
    }

    public int size() {
        if (this.dimsData == null) {
            return 0;
        }
        return this.dimsData.size();
    }

    public DimsData getDimsData(int n) {
        if (this.dimsData == null) {
            return null;
        }
        return this.dimsData.get(n);
    }

    public Iterator<DimsData> iterator() {
        if (this.dimsData == null) {
            return null;
        }
        return this.dimsData.iterator();
    }

    public void clear() {
        if (this.dimsData != null) {
            this.dimsData.clear();
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        int n = 0;
        for (DimsData dimsData : this.dimsData) {
            int n2 = nArray != null ? nArray[n] : -1;
            stringBuilder.append(dimsData.getUserString(n2));
            if (dimsData != this.dimsData.get(this.dimsData.size() - 1)) {
                stringBuilder.append(",  ");
            }
            ++n;
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    public boolean isRangeDefined() {
        for (DimsData dimsData : this.getDimsData()) {
            if (dimsData.getSliceRange() == null) continue;
            return true;
        }
        return false;
    }
}

